define("app",[],function(){return angular.module("JetBackupApp",["ngRoute","ngAnimate","ngSanitize","ngMaterial","moment-picker","ui.bootstrap","angular-loading-bar","jm.i18next"]).config(["$routeProvider","cfpLoadingBarProvider","momentPickerProvider",function(e,t,a){a.options({minutesStep:5,autoclose:!0,format:"HH:mm"}),t.includeSpinner=!1,t.includeBar=!0,t.parentSelector="#loading-bar-container";var a=window.PAGE.mfa,t=window.PAGE.path.media+"/views",n=window.PAGE.info.version,o={permissions:{except:["isLicenseIssue"],redirectTo:{isLicenseIssue:"/license"}}};a.isEnabled&&!a.isValid?e.otherwise({templateUrl:t+"/mfa.htm?v="+n}):e.when("/settings/:section",{templateUrl:t+"/settings.htm?v="+n,data:o}).when("/schedules",{templateUrl:t+"/schedules.htm?v="+n,data:o}).when("/profile",{templateUrl:t+"/profile.htm?v="+n,data:o}).when("/mfa",{templateUrl:t+"/mfa.htm?v="+n,data:o}).when("/queue",{templateUrl:t+"/queue.htm?v="+n,data:o}).when("/downloads",{templateUrl:t+"/downloads.htm?v="+n,data:o}).when("/alerts",{templateUrl:t+"/alerts.htm?v="+n,data:o}).when("/system",{templateUrl:t+"/system.htm?v="+n,data:o}).when("/backups",{templateUrl:t+"/backups.htm?v="+n,data:o}).when("/jobs",{templateUrl:t+"/jobs.htm?v="+n,data:o}).when("/destinations",{templateUrl:t+"/destinations.htm?v="+n,data:o}).when("/404",{templateUrl:t+"/404.htm?v="+n}).when("/license",{templateUrl:t+"/license.htm?v="+n,data:{permissions:{only:"isLicenseIssue",redirectTo:"/"}}}).when("/",{templateUrl:t+"/dashboard.htm?v="+n,data:o}).otherwise("/404")}]).controller("JetBackup",["$rootScope","lang","consts","popup",function(a,e,t,n){a.account=window.PAGE.account,a.configuration=window.PAGE.configuration,a.integration=window.PAGE.integration,a.info=window.PAGE.info,a.path=window.PAGE.path,a.license=window.PAGE.license,a.lang=e,a.const=t,a.primaryURL=a.path.location+window.location.search+"#!",a.expandedRow={},a.openActions=function(e,t){a.expandedRow[t=void 0===t?"general":t]=void 0!==a.expandedRow[t]&&a.expandedRow[t]===e?void 0:e},a.isOpenedActions=function(e,t){return a.expandedRow[t=void 0===t?"general":t]===e},a.menuItem="Dashboard",a.$on("menuItem",function(e,t){a.menuItem=t}),a.includePath=function(e,t){return e?a.path.media+"/"+(t=t||"views")+"/"+e+".htm?v="+a.info.version:""},a.downloadFile=function(e){var t=/\?/.test(a.path.download)?"&":"?";window.location=a.path.download+t+"download_id="+e},a.downloadLog=function(e){var t=/\?/.test(a.path.download)?"&":"?";window.location=a.path.download+t+"queue_item_id="+e},a.callSupport=function(){n.open({size:"lg",template:"modal/callSupport",controller:"callSupport",resolve:{}}).result.then(function(e){},function(){})},a.$on("$routeChangeStart",function(){e.initNS("dashboard")})}]).factory("responseObserver",["$q","storage",function(e,t){return{responseError:function(e){}}}])}),define("controllers/queueHandler",["app"],function(e){e.controller("queueHandler",["$rootScope","$scope","$location","$timeout","$interval","api","alert","params","consts",function(e,n,t,a,o,i,s,l,r){let{backupObject:c,[r.QUEUE_TYPE_FIELD]:u}=l,d=(n.backupObject=c,n.queueType=u,n.selectedDestinationId=0<c.destinations.length&&void 0!==c.destinations[0].id?c.destinations[0].id:0,t=>{var e=c.destinations.find(e=>e.id===t);return e?e.snap_id:null});n.selectDestination=function(e){d(e)?n.selectedDestinationId=e:s.error("Invalid destination selected.")},n.queueHandler=function(e,t){var a=d(n.selectedDestinationId);a?(a={[r.ID_FIELD]:a,[r.QUEUE_TYPE_FIELD]:u},i.addToQueue({data:a,success:function(e,t){n.loading=!1,s.success(t),n.$dismiss()},failed:function(e){n.loading=!1,s.error(e)}})):s.error("Failed to determine snap_id for the selected destination.")}}])}),define("controllers/dashboard",["app"],function(e){e.controller("dashboard",["$rootScope","$scope","$location","$timeout","$interval","api",function(e,a,t,n,o,i){e.$emit("menuItem","Dashboard"),a.stats={alerts:0,snapshots:0,snapshots_size:0,total_queue_pending:0,total_queue_processing:0,total_queue_completed:0,total_queue_aborted:0},i.getDashboard({success:function(e,t){a.stats=e.statistics},failed:function(e){}})}])}),define("controllers/destinations",["app"],function(e){e.controller("destinations",["$rootScope","$scope","$location","$timeout","$interval","api","meta","alert","popup","consts","lang",function(t,n,e,a,o,i,s,l,r,c,u){function d(e,t={}){i[e]({data:t,success:function(e,t){n.loading=!1,l.success(t),n.fetch()},failed:function(e){l.error(e),n.loading=!1}})}t.$emit("menuItem","Destinations"),n.destinations=[],n.loading=!1,n.hasActiveJetStorage=!1,n.initialLoading=!0,n.visibleDetailIndex=null,n.buttonLoading={},n.hasValidLicense=t.license&&"Active"===t.license.status,n.actions=[{name:"manage",label:"Manage",icon:"fa-cog"},{name:"validate",label:"Validate",icon:"fa-check-circle"},{name:"reindex",label:"Reindex",icon:"fa-sync"},{name:"delete",label:"Delete",icon:"fa-trash"}],n.setButtonLoading=function(e,t,a){n.buttonLoading[e]||(n.buttonLoading[e]={}),n.buttonLoading[e][t]=a},n.isButtonLoading=function(e,t){return n.buttonLoading[e]&&n.buttonLoading[e][t]},n.toggleDetail=function(e){n.visibleDetailIndex===e?n.visibleDetailIndex=null:n.visibleDetailIndex=e},n.isDetailVisible=function(e){return n.visibleDetailIndex===e},n.performAction=function(e,t){n.setButtonLoading(e,t,!0);var a={manage:n.manage,validate:n.validate,reindex:n.reindex,delete:n.delete,toggleExportConfig:n.toggleExportConfig,setStatus:n.setStatus}[t];a?Promise.resolve(a(e)).finally(()=>{n.setButtonLoading(e,t,!1)}):(console.log("Unknown action:",t),n.setButtonLoading(e,t,!1))},n.setStatus=function(e){d("enableDestination",{[c.ID_FIELD]:e})},n.toggleExportConfig=function(e){d("destinationSetExportConfig",{[c.ID_FIELD]:e})},n.manage=function(e){n.manageDestination(e)},n.validate=function(e){d("validateDestination",{[c.ID_FIELD]:e})},n.reindex=function(e){d("addToQueue",{[c.ID_FIELD]:e,[c.QUEUE_TYPE_FIELD]:c.QUEUE_TYPE_REINDEX})},n.delete=function(e){d("deleteDestination",{[c.ID_FIELD]:e})},n.meta=s.new("destinations"),n.metaData=n.meta.getData(),n.meta.getSortBy()||n.meta.setSortBy("name"),n.meta.getSortDirection()||n.meta.setSortDirection("asc"),n.meta.setSortFields(["name","read_only","enable","export_config","notes"]),n.meta.setTotalItems(n.destinations.length),n.manageDestination=function(e=null){n.icons={destinations_icon:t.configuration.UI.plugin_path+"/public/images/icon/destination/icons.png"},n.loading=!1,r.open({size:"xl",template:"modal/manageDestination",controller:"manageDestination",scope:n,resolve:{destinationID:function(){return e}}}).result.then(function(e){n.fetch()},function(){})},n.fetch=function(){var e;n.loading||(n.loading=!0,n.destinations=[],e={sort:{},skip:n.meta.getSkip(),limit:n.meta.getPageSize(),filter:n.meta.getFilter()},n.filter&&(e.find.type=n.filter),e.sort[n.meta.getSortBy()]=n.meta.getSortDirection(),i.listDestinations({data:e,success:function(e,t){n.loading=!1,n.initialLoading&&(n.initialLoading=!1),n.loadingDestinations=!1,n.meta.setTotalItems(e.total),n.meta.calculate(e.destinations),n.destinations=e.destinations,n.hasActiveJetStorage=n.destinations.some(function(e){return"JetStorage"===e.type&&!0===e.enabled})},failed:function(e){n.loading=!1,n.initialLoading=!1,l.error(e)}}))},a(n.fetch)}])}),define("controllers/schedules",["app"],function(e){e.controller("schedules",["$rootScope","$scope","$location","$timeout","$interval","api","alert","meta","popup","consts",function(e,n,t,a,o,i,s,l,r,c){e.$emit("menuItem","Schedules"),n.schedules=[],n.visibleDetailIndex=null,n.initialLoading=!0,n.meta=l.new("schedules"),n.metaData=n.meta.getData(),n.meta.getSortBy()||n.meta.setSortBy("_id"),n.meta.getSortDirection()||n.meta.setSortDirection("desc"),n.meta.setSortFields(["created","structure","destination","size"]),n.meta.setTotalItems(n.schedules.length),n.actions=[{name:"manage",label:"Manage",icon:"fa-cog"},{name:"delete",label:"Delete",icon:"fa-trash"}],n.toggleDetail=function(e){n.visibleDetailIndex===e?n.visibleDetailIndex=null:n.visibleDetailIndex=e},n.isDetailVisible=function(e){return n.visibleDetailIndex===e},n.deleteSchedule=function(e){var t;t="deleteSchedule",e={[c.ID_FIELD]:e},i[t]({data:e,success:function(e,t){n.loading=!1,s.success(t),n.fetch()},failed:function(e){s.error(e),n.loading=!1}})},n.manageSchedule=function(e){var t;[t=null]=[e],r.open({size:"xl",template:"modal/manageSchedule",controller:"manageSchedule",scope:n,resolve:{scheduleID:function(){return t}}}).result.then(function(e){n.fetch()},function(){})},n.performAction=function(e,t){var a={manage:n.manageSchedule,delete:n.deleteSchedule}[t];a?a(e):console.log("Unknown action:",t)},n.fetch=function(){var e;n.loading||(n.loading=!0,n.schedules=[],e={sort:{},skip:n.meta.getSkip(),limit:n.meta.getPageSize(),filter:n.meta.getFilter(),find:{}},n.filter&&(e.find.type=n.filter),e.sort[n.meta.getSortBy()]=n.meta.getSortDirection(),i.listSchedules({data:e,success:function(e,t){n.meta.setTotalItems(e.total),n.meta.calculate(e.schedules),n.schedules=e.schedules,n.loading=!1,n.initialLoading&&(n.initialLoading=!1)},failed:function(e){s.error(e),n.loading=!1,n.initialLoading=!1}}))},a(n.fetch)}])}),define("controllers/system",["app"],function(e){e.controller("system",["$rootScope","$scope","$location","$timeout","$interval","api","alert","lang",function(e,a,t,n,o,i,s,l){e.$emit("menuItem","System"),a.loading=!1,a.keys={timezone:l.t("Timezone"),show_time:l.t("Timezone Hour"),loaded_language:l.t("Loaded Language Code"),open_files_limit:l.t("Open Files Limit"),memory_limit:l.t("Memory Limit"),max_execution_time:l.t("Max Execution Time"),post_max_size:l.t("Post Max Size"),upload_max_filesize:l.t("Upload Max Size"),wordpress_path:l.t("WordPress Public Path"),jetbackup_data_dir:l.t("JetBackup Data Directory"),free_disk_space:l.t("Free Disk Space"),php_version:l.t("PHP Web Version"),php_cli:l.t("PHP CLI Version"),available_cli:l.t("Available CLI Functions")},a.getMemoryValue=function(e){if(!e)return 0;var t=e.replace(/[0-9]/g,"").trim(),a=parseInt(e,10);switch(t.toUpperCase()){case"G":return 1024*a;case"K":return a/1024;default:return a}},a.system=[],a.fetch=function(){a.loading||(a.loading=!0,i.getSystemInfo({success:function(e,t){a.system=e,a.loading=!1},failed:function(e){a.loading=!1,s.error(e)}}))},n(a.fetch)}])}),define("controllers/jobs",["app"],function(e){e.controller("jobs",["$rootScope","$scope","$location","$timeout","$interval","api","meta","alert","popup","consts","lang",function(a,o,e,t,n,i,s,l,r,c,u){function d(e=null){r.open({size:"xl",template:"modal/manageBackupJob",controller:"manageBackupJob",scope:o,resolve:{jobID:function(){return e}}}).result.then(function(e){o.fetch()},function(){})}function p(e,t={},a=()=>{},n=()=>{}){i[e]({data:t,success:function(e,t){o.loading=!1,l.success(t),o.fetch(),a()},failed:function(e){l.error(e),o.loading=!1,n()}})}a.$emit("menuItem","Jobs"),o.jobs=[],o.loading=!1,o.initialLoading=!0,o.visibleDetailIndex=null,o.buttonLoading={},o.backupContains=function(e){return{[c.BACKUP_ACCOUNT_CONTAINS_HOMEDIR]:u.t("Homedir"),[c.BACKUP_ACCOUNT_CONTAINS_DATABASE]:u.t("Database"),[c.BACKUP_ACCOUNT_CONTAINS_FULL]:u.t("Full")}[e]||u.t("Unknown")},o.actions=[{name:"manage",label:"Manage",icon:"fa-cog"},{name:"runNow",label:"Run Now",icon:"fa-play-circle"},{name:"duplicate",label:"Duplicate",icon:"fa-copy"},{name:"delete",label:"Delete",icon:"fa-trash"}],o.setButtonLoading=function(e,t,a){o.buttonLoading[e]||(o.buttonLoading[e]={}),o.buttonLoading[e][t]=a},o.isButtonLoading=function(e,t){return o.buttonLoading[e]&&o.buttonLoading[e][t]},o.toggleDetail=function(e){o.visibleDetailIndex=o.visibleDetailIndex===e?null:e},o.isDetailVisible=function(e){return o.visibleDetailIndex===e},o.performAction=function(e,t){o.setButtonLoading(e,t,!0);var a={manage:o.manageJob,runNow:o.runJobNow,duplicate:o.duplicateJob,delete:o.deleteJob,enableJob:o.enableJob}[t];a?Promise.resolve(a(e)).finally(()=>{o.setButtonLoading(e,t,!1)}):(console.error("Unknown action:",t),o.setButtonLoading(e,t,!1))},o.manageJob=function(t){return new Promise(e=>{d(t),e()})},o.runJobNow=function(a){return new Promise((e,t)=>{p("addToQueue",{[c.ID_FIELD]:a,[c.QUEUE_TYPE_FIELD]:c.QUEUE_TYPE_BACKUP},e,t)})},o.duplicateJob=function(e){p("duplicateBackupJob",{[c.ID_FIELD]:e})},o.deleteJob=function(e){p("deleteBackupJob",{[c.ID_FIELD]:e})},o.enableJob=function(e){p("enableBackupJob",{[c.ID_FIELD]:e})},o.createNewJob=function(){d(null)},o.meta=s.new("jobs"),o.metaData=o.meta.getData(),o.meta.getSortBy()||o.meta.setSortBy("name"),o.meta.getSortDirection()||o.meta.setSortDirection("asc"),o.meta.setSortFields(["created","structure","destination","size"]),o.meta.setTotalItems(o.jobs.length),o.fetch=function(){var e;o.loading||(o.loading=!0,o.jobs=[],e={sort:{},skip:o.meta.getSkip(),limit:o.meta.getPageSize(),filter:o.meta.getFilter()},o.filter&&(e.find.type=o.filter),e.sort[o.meta.getSortBy()]=o.meta.getSortDirection(),i.listBackupJobs({data:e,success:function(e,t){o.meta.setTotalItems(e.total),o.meta.calculate(e.jobs),o.jobs=e.jobs,o.primaryURL=a.primaryURL,o.loading=!1,o.initialLoading&&(o.initialLoading=!1)},failed:function(e){l.error(e),o.loading=!1,o.initialLoading=!1}}))},t(o.fetch)}])}),define("controllers/alerts",["app"],function(e){e.controller("alerts",["$rootScope","$scope","$location","$timeout","$interval","api","meta","alert",function(e,a,t,n,o,i,s,l){e.$emit("menuItem","Alerts"),a.alerts=[],a.loading=!1,a.meta=s.new("alerts"),a.metaData=a.meta.getData(),a.meta.getSortBy()||a.meta.setSortBy("name"),a.meta.getSortDirection()||a.meta.setSortDirection("asc"),a.meta.setSortFields(["created","title","message","source","level"]),a.meta.setTotalItems(a.alerts.length),a.clearAlerts=function(){i.clearAlerts({success:function(e,t){a.loading=!1,l.success(t),a.fetch()},failed:function(e){l.error(e),a.loading=!1}})},a.fetch=function(){var e;a.loading||(a.loading=!0,a.alerts=[],e={sort:{},skip:a.meta.getSkip(),limit:a.meta.getPageSize(),filter:a.meta.getFilter()},a.filter&&(e.find.type=a.filter),e.sort[a.meta.getSortBy()]=a.meta.getSortDirection(),i.listAlerts({data:e,success:function(e,t){a.loadingDestinations=!1,a.meta.setTotalItems(e.total),a.meta.calculate(e.alerts),a.alerts=e.alerts,a.loading=!1},failed:function(e){l.error(e),a.loading=!1}}))},n(a.fetch)}])}),define("controllers/backups",["app"],function(e){e.controller("backups",["$rootScope","$scope","$location","$timeout","$interval","api","meta","alert","popup","consts","lang",function(a,n,e,t,o,i,s,l,r,c,u){a.$emit("menuItem","Backups"),n.backups=[],n.loading=!1,n.initialLoading=!0,n.visibleDetailIndex=null,n.consts=c,n.isJetBackupLinux=function(){return!!(a.integration&&a.integration.installed&&a.integration.enabled)},n.backupStructure=function(e){return{[c.BACKUP_STRUCTURE_ARCHIVED]:u.t("Archived"),[c.BACKUP_STRUCTURE_COMPRESSED]:u.t("Compressed"),[c.BACKUP_STRUCTURE_INCREMENTAL]:u.t("Incremental")}[e]||u.t("Unknown")},n.backupContains=function(e){return{[c.BACKUP_ACCOUNT_CONTAINS_HOMEDIR]:u.t("Homedir"),[c.BACKUP_ACCOUNT_CONTAINS_DATABASE]:u.t("Database"),[c.BACKUP_ACCOUNT_CONTAINS_FULL]:u.t("Full")}[e]||u.t("Unknown")},n.isActionVisible=function(e,t){switch(e){case c.BACKUP_ACTION_RESTORE:return t.engine===c.ENGINE_WORDPRESS||t.engine===c.ENGINE_JETBACKUP_LINUX;case c.BACKUP_ACTION_DOWNLOAD:case c.BACKUP_ACTION_EXTRACT:return t.engine===c.ENGINE_WORDPRESS||t.engine===c.ENGINE_JETBACKUP_SGB;case c.BACKUP_ACTION_EXPORT:case c.BACKUP_ACTION_LOCK:case c.BACKUP_ACTION_DELETE:return t.engine===c.ENGINE_WORDPRESS;case c.BACKUP_ACTION_EDIT_NOTES:return t.engine===c.ENGINE_WORDPRESS||t.engine===c.ENGINE_JETBACKUP_LINUX||t.engine===c.ENGINE_JETBACKUP_SGB;default:return!1}},n.actions=[{name:c.BACKUP_ACTION_RESTORE,label:u.t("Restore"),icon:"fa-database"},{name:c.BACKUP_ACTION_DOWNLOAD,label:u.t("Download"),icon:"fa-download"},{name:c.BACKUP_ACTION_EXTRACT,label:u.t("Extract"),icon:"fa-file-archive"},{name:c.BACKUP_ACTION_EXPORT,label:u.t("Export"),icon:"fa-share-square"},{name:c.BACKUP_ACTION_LOCK,label:"Lock",icon:"fa-lock"},{name:c.BACKUP_ACTION_DELETE,label:"Delete",icon:"fa-trash"},{name:c.BACKUP_ACTION_EDIT_NOTES,label:u.t("Edit Notes"),icon:"fa-edit"}],n.toggleDetail=function(e){n.visibleDetailIndex===e?n.visibleDetailIndex=null:n.visibleDetailIndex=e},n.isDetailVisible=function(e){return n.visibleDetailIndex===e},n.meta=s.new("backups"),n.metaData=n.meta.getData(),n.meta.getSortBy()||n.meta.setSortBy("name"),n.meta.getSortDirection()||n.meta.setSortDirection("asc"),n.meta.setSortFields(["created","structure","destination","size"]),n.meta.setTotalItems(n.backups.length),n.performAction=function(e,t){var a={restore:n.restore,download:n.download,import:n.import,extract:n.extract,export:n.export,editNotes:n.editNotes,lock:n.lock,delete:n.delete,reindex:n.reindex}[t];a?a(e):console.log("Unknown action:",t)},n.reindex=function(){var e={[c.ID_FIELD]:0,[c.QUEUE_TYPE_FIELD]:c.QUEUE_TYPE_REINDEX};i.addToQueue({data:e,success:function(e,t){n.loading=!1,l.success(t)},failed:function(e){l.error(e),n.loading=!1}})},n.lock=function(e){r.open({size:"xl",template:"modal/lockBackup",controller:"lockBackup",scope:n,resolve:{backupObject:function(){return e}}}).result.then(function(e){n.fetch()},function(){})},n.delete=function(e){r.open({size:"xl",template:"modal/deleteBackup",controller:"deleteBackup",scope:n,resolve:{backupObject:function(){return e}}}).result.then(function(e){n.fetch()},function(){})},n.editNotes=function(e){r.open({size:"xl",template:"modal/editBackupNotes",controller:"editBackupNotes",scope:n,resolve:{backupObject:function(){return e}}}).result.then(function(e){n.fetch()},function(){})},n.export=function(e){let t={cpanel_icon:a.configuration.UI.plugin_path+"/public/images/panels/cpanel-orange.png",da_icon:a.configuration.UI.plugin_path+"/public/images/panels/logo_directadmin.svg"};r.open({size:"lg",template:"modal/exportBackup",controller:"exportBackup",scope:n,resolve:{backupObject:function(){return e},icons:function(){return t}}}).result.then(function(e){n.fetch()},function(){})},n.extract=function(e){r.open({size:"xl",template:"modal/extractBackup",controller:"queueHandler",scope:n,resolve:{params:function(){return{backupObject:e,[c.QUEUE_TYPE_FIELD]:c.QUEUE_TYPE_EXTRACT}}}}).result.then(function(e){n.fetch()},function(){})},n.restore=function(e){r.open({size:"xl",template:"modal/restoreBackup",controller:"restoreBackup",scope:n,resolve:{backupObject:function(){return e}}}).result.then(function(e){n.fetch()},function(){})},n.download=function(e){r.open({size:"xl",template:"modal/downloadBackup",controller:"queueHandler",scope:n,resolve:{params:function(){return{backupObject:e,[c.QUEUE_TYPE_FIELD]:c.QUEUE_TYPE_DOWNLOAD}}}}).result.then(function(e){n.fetch()},function(){})},n.import=function(){r.open({size:"lg",template:"modal/importBackup",controller:"importBackup",resolve:{}}).result.then(function(e){n.fetch()},function(){})},n.readableBackups=function(e){let u=[],d={};return e.forEach(e=>{let t=e.name;var a=e.destination_id,n=e.destination_name||"",o=e._id,i=e.locked?1:0,s=e.deleted?1:0,l=e.notes||"",r=e.size;d[a]||(d[a]=n);let c=u.find(e=>e.name===t);c?(c.destinations.push({id:a,snap_id:o,locked:i,deleted:s,name:d[a],notes:l}),c.snap_ids.includes(o)||c.snap_ids.push(o)):((c=angular.copy(e)).destinations=[{id:a,snap_id:o,locked:i,deleted:s,name:d[a],notes:l}],delete c.destination_id,delete c._id,delete c.destination_name,c.snap_ids=[o],c.size=r,u.push(c))}),{backups:u,total:u.length}},n.fetch=function(){var e;n.loading||(n.loading=!0,n.backups=[],e={sort:{},skip:n.meta.getSkip(),limit:n.meta.getPageSize(),filter:n.meta.getFilter()},n.filter&&(e.find.type=n.filter),e.sort[n.meta.getSortBy()]=n.meta.getSortDirection(),i.listBackups({data:e,success:function(e,t){n.loading=!1,n.initialLoading&&(n.initialLoading=!1);var a=n.readableBackups(e.backups);n.backups=a.backups,n.meta.setTotalItems(e.total),n.meta.calculate(a.backups)},failed:function(e){l.error(e),n.loading=!1,n.initialLoading=!1}}))},t(n.fetch)}])}),define("controllers/queue",["app"],function(e){e.controller("queue",["$rootScope","$scope","$location","$timeout","$interval","api","meta","alert","consts","lang","popup",function(t,n,e,a,o,i,s,l,r,c,u){function d(e,t={}){i[e]({data:t,success:function(e,t){n.loading=!1,l.success(t),n.fetch()},failed:function(e){l.error(e),n.loading=!1}})}t.$emit("menuItem","Queue"),n.queueItems=[],n.loading=!1,n.initialLoading=!0,n.meta=s.new("queueItems"),n.metaData=n.meta.getData(),n.visibleDetailIndex=null,(n.consts=r).STATUS_NAMES={[r.QUEUE_STATUS_PENDING]:c.t("Pending"),[r.QUEUE_STATUS_STARTED]:c.t("Started"),[r.QUEUE_STATUS_PREPARING]:c.t("Preparing"),[r.QUEUE_STATUS_DONE]:c.t("Completed"),[r.QUEUE_STATUS_PARTIALLY]:c.t("Completed with errors"),[r.QUEUE_STATUS_FAILED]:c.t("Failed"),[r.QUEUE_STATUS_ABORTED]:c.t("Aborted"),[r.QUEUE_STATUS_NEVER_FINISHED]:c.t("Never Finished")},n.actions=[{name:r.QUEUE_TYPE_DOWNLOAD_NAME,label:c.t("Download"),icon:"fa-download"},{name:r.QUEUE_TYPE_ABORT_NAME,label:c.t("Abort"),icon:"fa-ban"},{name:r.QUEUE_TYPE_STARTOVER_NAME,label:c.t("Start Over"),icon:"fa-redo"},{name:r.QUEUE_TYPE_DOWNLOAD_LOGS_NAME,label:c.t("Download Log"),icon:"fa-download"},{name:r.QUEUE_TYPE_VIEW_LOGS_NAME,label:c.t("View Log"),icon:"fa-search"},{name:r.QUEUE_TYPE_COMPLETE_RESTORE,label:c.t("Complete Restore >>"),icon:"fa-flag-checkered"},{name:r.QUEUE_TYPE_EXTRACT_NAME,label:c.t("View Path"),icon:"fa-folder-open"}],n.isActionVisible=function(e,t){switch(e){case r.QUEUE_TYPE_STARTOVER_NAME:return t.status>=r.QUEUE_STATUS_FAILED;case r.QUEUE_TYPE_DOWNLOAD_NAME:return!(t.status!==r.QUEUE_STATUS_DONE&&t.status!==r.QUEUE_STATUS_PARTIALLY||t.type!==r.QUEUE_TYPE_DOWNLOAD&&t.type!==r.QUEUE_TYPE_EXPORT);case r.QUEUE_TYPE_ABORT_NAME:return t.status<r.QUEUE_STATUS_DONE;case r.QUEUE_TYPE_DOWNLOAD_LOGS_NAME:case r.QUEUE_TYPE_VIEW_LOGS_NAME:return t.status>r.QUEUE_STATUS_PENDING;case r.QUEUE_TYPE_COMPLETE_RESTORE:return t.type===r.QUEUE_TYPE_RESTORE&&t.status===r.QUEUE_EXTERNAL_RESTORE_READY;case r.QUEUE_TYPE_EXTRACT_NAME:return(t.status===r.QUEUE_STATUS_DONE||t.status===r.QUEUE_STATUS_PARTIALLY)&&t.type===r.QUEUE_TYPE_EXTRACT;default:return!1}},n.toggleDetail=function(e){n.visibleDetailIndex===e?n.visibleDetailIndex=null:n.visibleDetailIndex=e},n.isDetailVisible=function(e){return n.visibleDetailIndex===e},n.performAction=function(e,t){var a={downloadLogs:n.downloadLogs,getLog:n.getLog,download:n.download,startover:n.startOverQueueItem,abort:n.abortQueueItem,clearCompleted:n.clearCompleted,completeRestore:n.completeRestore,showExtractPath:n.showExtractPath}[t];a?a(e):console.log("Unknown action:",t)},n.showExtractPath=function(t){if(n.queueItems&&Array.isArray(n.queueItems)){var a=n.queueItems.find(e=>e._id===t);if(a&&a.item_data&&a.item_data.extract_path){let e=a.item_data.extract_path;u.open({size:"lg",template:"modal/showExtractedPath",controller:"showExtractedPath",resolve:{extractPath:function(){return e}}}).result.then(function(e){},function(){})}}},n.getRestoreUrl=function(t){if(n.queueItems&&Array.isArray(n.queueItems)){var e=n.queueItems.find(e=>e._id===t);if(e&&e.item_data&&e.item_data.restore_url)return e.item_data.restore_url}return null},n.clearCompleted=function(e){d("clearCompletedQueueItems",{[r.ID_FIELD]:e})},n.completeRestore=function(e){e=n.getRestoreUrl(e);e?window.open(e,"_blank"):l.error(c.t("Restore URL not found"))},n.startOverQueueItem=function(e){d("startOverQueueItem",{[r.ID_FIELD]:e})},n.downloadLogs=function(e){t.downloadLog(e)},n.getLog=function(e=null){e||l.error(c.t("Log ID not found")),u.open({size:"lg",template:"modal/viewLog",controller:"viewLog",resolve:{queueId:function(){return e}}}).result.then(function(e){},function(){})},n.download=function(e){e||l.error(c.t("Download ID not found")),t.downloadFile(e)},n.abortQueueItem=function(e){d("abortQueueItem",{[r.ID_FIELD]:e})},n.meta.getSortBy()||n.meta.setSortBy("created"),n.meta.getSortDirection()||n.meta.setSortDirection("desc"),n.meta.setSortFields(["created","progress.message","type"]),n.meta.setTotalItems(n.queueItems.length),n.fetch=function(){var e;n.loading||(n.loading=!0,e={sort:{},skip:n.meta.getSkip(),limit:n.meta.getPageSize(),filter:n.meta.getFilter()},n.filter&&(e.find.type=n.filter),e.sort[n.meta.getSortBy()]=n.meta.getSortDirection(),i.listQueueItems({data:e,success:function(e){var t,a;n.loading=!1,n.initialLoading&&(n.initialLoading=!1),angular.equals(n.queueItems,e.items)||(-1!==(a=(t=e.items).findIndex(e=>n.isActionVisible(r.QUEUE_TYPE_COMPLETE_RESTORE,e)))&&(a=t.splice(a,1)[0],t.unshift(a),n.visibleDetailIndex=0),n.queueItems=t,n.meta.setTotalItems(e.total),n.meta.calculate(e.items))},failed:function(e){l.error(e),n.loading=!1}}))},a(n.fetch);let p=o(n.fetch,5e3);n.$on("$destroy",function(){o.cancel(p)})}])}),define("controllers/downloads",["app"],function(e){e.controller("downloads",["$rootScope","$scope","$location","$timeout","$interval","api","meta","alert","popup","consts","lang",function(t,a,e,n,o,i,s,l,r,c,u){t.$emit("menuItem","Downloads"),a.loading=!1,a.initialLoading=!0,a.downloads={},a.meta=s.new("downloads"),a.metaData=a.meta.getData(),a.meta.getSortBy()||a.meta.setSortBy("name"),a.meta.getSortDirection()||a.meta.setSortDirection("asc"),a.meta.setSortFields(["created","filename","size"]),a.meta.setTotalItems(a.downloads.length),a.toggleDetail=function(e){a.visibleDetailIndex===e?a.visibleDetailIndex=null:a.visibleDetailIndex=e},a.isDetailVisible=function(e){return a.visibleDetailIndex===e},a.downloadBackup=function(e){e||l.error(u.t("Download ID not found")),t.downloadFile(e)},a.deleteBackup=function(e){i.deleteDownload({data:{[c.ID_FIELD]:e},success:function(e,t){l.success(u.t("Download deleted successfully")),a.fetch()},failed:function(e){l.error(e)}})},a.fetch=function(){var e;a.loading||(a.loading=!0,e={sort:{},skip:a.meta.getSkip(),limit:a.meta.getPageSize(),filter:a.meta.getFilter()},a.filter&&(e.find.type=a.filter),e.sort[a.meta.getSortBy()]=a.meta.getSortDirection(),i.listDownloads({data:e,success:function(e,t){a.loading=!1,a.initialLoading&&(a.initialLoading=!1),a.downloads=e.downloads,a.meta.setTotalItems(e.total),a.meta.calculate(e.downloads),a.system=e},failed:function(e){a.loading=!1,a.initialLoading=!1,l.error(e)}}))},n(a.fetch)}])}),define("controllers/settings",["app"],function(e){e.controller("settings",["$rootScope","$scope","$routeParams","$location","$timeout","$interval","api","lang","util","alert","consts",function(t,n,e,a,o,i,s,l,r,c,u){t.$emit("menuItem","Settings"),n.currentSection="",n.sectionPage="",n.details={},n.saveData={},n.timezones=t.configuration.UI.timezones,n.is_windows=t.configuration.env.is_windows,n.chunks_list=u.CHUNK_SIZES_LIST,n.execution_time_list=u.EXECUTION_TIME_LIST,n.sections=[{[u.ID_FIELD]:"general",name:l.t("General"),template:"general",icon:"fa-cogs"},{[u.ID_FIELD]:"security",name:l.t("Security"),template:"security",icon:"fa-cogs"},{[u.ID_FIELD]:"automation",name:l.t("Automation"),template:"automation",icon:"fa-cogs"},{[u.ID_FIELD]:"performance",name:l.t("Performance"),template:"performance",icon:"fa-cogs"},{[u.ID_FIELD]:"logging",name:l.t("Logging"),template:"logging",icon:"fa-cogs"},{[u.ID_FIELD]:"notifications",name:l.t("Notifications"),template:"notifications",icon:"fa-cogs"},{[u.ID_FIELD]:"maintenance",name:l.t("Maintenance"),template:"maintenance",icon:"fa-cogs"},{[u.ID_FIELD]:"updates",name:l.t("Updates"),template:"updates",icon:"fa-cogs"},{[u.ID_FIELD]:"restore",name:l.t("Restore"),template:"restore",icon:"fa-cogs"},{[u.ID_FIELD]:"integrations",name:l.t("Integrations"),template:"integrations",icon:"fa-cogs"}],n.getSection=function(e){for(var t=0;t<n.sections.length;t++)if(n.sections[t][u.ID_FIELD]===e)return n.sections[t];return n.sections[0]},n.loadSection=function(e){n.isLoadingSection=!0,n.currentSection=e,n.sectionPage=n.includePath("settings/"+e.template)},n.changeSection=function(e){a.path("/settings/"+e[u.ID_FIELD])},n.loadSection(n.getSection(e.section||"general")),n.sendTestEmail=function(){var e;n.sendingEmail||(n.sendingEmail=!0,e={alternate_email:n.saveData.ALTERNATE_EMAIL},s.sendTestEmail({data:e,success:function(e,t){n.sendingEmail=!1,c.success(t)},failed:function(e){n.sendingEmail=!1,c.error(e)}}))},n.toggleIntegration=function(e){n.saveData.integrations||(n.saveData.integrations=[]);var t=n.saveData.integrations.indexOf(e);-1<t?n.saveData.integrations.splice(t,1):n.saveData.integrations.push(e)},n.ok=function(){if(!n.loading){n.loading=!0;let a=n.details.hasOwnProperty(u.MANAGE_SETTINGS_SECURITY_MFA_ENABLED)?Boolean(n.details[u.MANAGE_SETTINGS_SECURITY_MFA_ENABLED]):void 0;var e=r.saveParams(n.saveData,n.details);s.manageSettings(n.currentSection._id,{data:e,success:function(e,t){n.loading=!1,c.success(t);t=n.saveData.hasOwnProperty(u.MANAGE_SETTINGS_SECURITY_MFA_ENABLED)?Boolean(n.saveData[u.MANAGE_SETTINGS_SECURITY_MFA_ENABLED]):void 0;!1===a&&!0===t||"automation"===n.currentSection._id?location.reload():n.fetch()},failed:function(e){c.error(e),n.loading=!1}})}},n.fetch=function(){n.loading||(n.loading=!0,s.getSettings(n.currentSection[u.ID_FIELD],{success:function(e){n.loading=!1,n.isLoadingSection=!1,n.details=e,n.saveData=r.duplicateObject(n.details),void 0!==e.LICENSE_STATUS&&(t.license.status=e.LICENSE_STATUS)},failed:function(e){n.loading=!1,n.isLoadingSection=!1,c.error(e)}}))},o(n.fetch)}])}),define("controllers/mfa",["app"],function(e){e.controller("mfa",["$rootScope","$scope","$location","$timeout","$interval","api","lang","alert","consts",function(e,a,t,n,o,i,s,l,r){e.$emit("menuItem","Dashboard"),a.isValidating=!1,a.isSkipping=!1,a.validateMFA=function(e){a.isValidating||(a.isValidating=!0,i.validateMFA({data:{code:e},success:function(){l.success(s.t("MFA Code is Valid! Redirecting...")),a.isValidating=!1,location.reload()},failed:function(e){l.error(s.t(e||"Failed to activate MFA. Please try again.")),a.isValidating=!1}}))},a.skipMfa=function(){var e;a.isSkipping||confirm(s.t("Are you sure you want to skip enabling MFA? Your plugin may be less secure."))&&(a.isSkipping=!0,(e={})[r.MANAGE_SETTINGS_SECURITY_MFA_ENABLED]=!"Security",i.manageSettings("Security",{data:e,success:function(e,t){l.success(s.t("MFA Disabled! Redirecting...")),a.isSkipping=!1,location.reload()},failed:function(e){l.error(e),a.isSkipping=!1}}))},a.fetch=function(){a.loading||(a.loading=!0,i.getQRCode({success:function(e,t){a.qrCode=e.code,a.isFirstTime=e.isFirstTime,a.loading=!1},failed:function(e){l.error(e),a.loading=!1}}))},n(a.fetch)}])}),define("controllers/fileManager",["app"],function(e){e.controller("fileManager",["$uibModalInstance","$scope","$timeout","$location","api","meta","lang","consts","alert","pathManager","files","backup",function(r,c,e,t,a,n,o,i,s,l,u,d){var p,f=[];for(p in u)f.push(p);c.manager=l.new(f),c.files=u,c.loadingFiles=!1,c.currentPath="",c.breadcrumbs=[],c.filesIndex={},c.checkedAll=!1;function g(e){"/"===e.path&&(e.name="/root"),c.breadcrumbs.unshift(e),void 0!==e.parent&&g(e.parent)}var _=n.new("file_manager");c.meta=_,c.metaData=_.getData(),_.getSortBy()||_.setSortBy("type"),_.getSortDirection()||_.setSortDirection("asc"),_.setSortFields(["name","type","size","created"]),_.setPageSize(10),_.setPageSizes([10,25,50,100]),_.setTotalItems(c.files.length),c.currentFile=void 0,c.fetch=function(o,e){void 0===o?o=c.currentFile:c.currentFile=o,void 0===o.path&&(o.path="/"),c.loadingFiles=!0,c.files=[],c.breadcrumbs=[],g(o),e&&_.setCurrentPage(1);e={sort:{},skip:_.getSkip(),limit:_.getPageSize(),find:{},filter:""};e._id=d._id,e.location=o.path,e.sort[_.getSortBy()]=_.getSortDirectionInt(),a.fileManager({data:e,success:function(e){for(var t,a,n=0;n<e.files.length;n++)e.files[n].path=o.path+("/"===o.path?"":"/")+e.files[n].name,e.files[n].parent=o;_.setTotalItems(e.total),_.calculate(e.files),t=e,a=o,c.filesIndex[a.path]=t,c.files=t.files,c.loadingFiles=!1,c.calculateCheckedAll()},failed:function(e){c.errorMessage=e,c.loadingFiles=!1}})},c.uncheckAll=function(){for(var e in c.filesIndex)for(var t in c.filesIndex[e].files)null!=c.filesIndex[e].files[t]&&void 0!==c.filesIndex[e].files[t].checked&&c.filesIndex[e].files[t].checked&&(c.filesIndex[e].files[t].checked=!1)},c.toggleCheckAll=function(){c.checkedAll=!c.checkedAll;for(var e=0;e<c.files.length;e++){var t,a=c.files[e];"File"!==a.type&&"Directory"!==a.type||(t=c.manager.isExists(a.path),c.checkedAll&&!t?c.manager.addPath(a.path):!c.checkedAll&&t&&c.manager.removePath(a.path))}},c.calculateCheckedAll=function(){for(var e=0;e<c.files.length;e++){var t=c.files[e];if("File"===t.type||"Directory"===t.type)if(!c.manager.isExists(t.path))return void(c.checkedAll=!1)}c.checkedAll=!0},c.toggleFile=function(e){c.manager.isExists(e.path)?c.manager.removePath(e.path):c.manager.addPath(e.path),c.calculateCheckedAll()},c.isDisabled=function(e){return c.manager.isChildren(e.path)},c.isChecked=function(e){return e.checked=c.manager.isExists(e.path)||c.manager.isChildren(e.path),e.checked},c.isChildrenChecked=function(e){return c.manager.isParent(e.path)},c.ok=function(){for(var e={},t=c.manager.getSelected(),a=0;a<t.length;a++){var n=t[a],o=n.replace(/.*\//,""),i=n.match(/.*\//).join("");if("/"!==i&&(i=i.replace(/\/$/,"")),void 0===c.filesIndex[i])e[n]={empty:!0};else for(var s=c.filesIndex[i].files,l=0;l<s.length;l++)if(s[l].name===o){e[n]=s[l];break}}r.close(e)},c.cancel=function(){r.dismiss()},c.init=function(){c.fetch({path:"/"}),c.calculateCheckedAll()},e(c.init)}])}),define("controllers/404",["app"],function(e){e.controller("404",["$rootScope","$scope","$location","$timeout","$interval","api","meta","alert","lang",function(e,t,a,n,o,i,s,l,r){e.$emit("menuItem","Dashboard")}])}),define("controllers/modal/manageDestination",["app"],function(e){e.controller("manageDestination",["$rootScope","$uibModalInstance","$scope","$timeout","api","meta","lang","destinationID","util","alert","consts",function(t,n,o,e,i,a,s,l,r,c,u){o.selectedDestinationType="Select",o.destinationTemplate="",o.loaded=!1,o.details={},o.saveData={},o.chunks_list=u.CHUNK_SIZES_LIST,o.disk_space_options=u.DESTINATIONS_DISK_SPACE_LIMIT,o.is_windows=t.configuration.env.is_windows,o.resetSaveData=function(){o.saveData={name:"",notes:"",read_only:!1,chunk_size:1,path:o.is_windows?"\\":"/",options:{}}},o.resetSaveData(),o.destinationTypes={JetStorage:{key:"JetStorage",display:"JetBackup Storage",iconClass:"jetbackup-jetstorage-dest",diskSpaceSupported:!1},Local:{key:"Local",display:"Local",iconClass:"jetbackup-local-dest",diskSpaceSupported:!0},FTP:{key:"FTP",display:"FTP",iconClass:"jetbackup-cloud-ftp",diskSpaceSupported:!1},SFTP:{key:"SFTP",display:"SFTP",iconClass:"jetbackup-cloud-ftp",diskSpaceSupported:!0},S3:{key:"S3",display:"S3 Compatible",iconClass:"jetbackup-cloud-amazon",diskSpaceSupported:!1},GoogleDrive:{key:"GoogleDrive",display:"Google Drive",iconClass:"jetbackup-cloud-google-drive",diskSpaceSupported:!0},OneDrive:{key:"OneDrive",display:"One Drive",iconClass:"jetbackup-cloud-one-drive",diskSpaceSupported:!0},DropBox:{key:"DropBox",display:"DropBox",iconClass:"jetbackup-cloud-dropbox",diskSpaceSupported:!0},Box:{key:"Box",display:"Box",iconClass:"jetbackup-cloud-box",diskSpaceSupported:!0},pCloud:{key:"pCloud",display:"pCloud",iconClass:"jetbackup-cloud-pcloud",diskSpaceSupported:!0}},o.isDiskSpaceSupported=function(){return o.saveData.type&&void 0!==o.destinationTypes[o.saveData.type]&&o.destinationTypes[o.saveData.type].diskSpaceSupported},o.selectDestinationType=function(e){if("active"===String(t.license.status).toLowerCase()||["local","jetstorage"].includes(String(e).toLowerCase()))switch(o.resetSaveData(),o.selectedDestinationType=o.destinationTypes[e].display,o.destinationTemplate=o.includePath("destinations/"+e),o.saveData.type=e,o.isOpen=!1,o.isDiskSpaceSupported()&&(o.saveData.free_disk=0),e){case"JetStorage":case"S3":o.saveData.chunk_size=5,o.chunks_list={"5MB":5,"6MB":6,"8MB":8,"10MB":10,"12MB":12,"14MB":14,"16MB":16,"20MB":20,"24MB":24,"32MB":32,"64MB":64};break;case"Box":o.saveData.chunk_size=20,o.chunks_list={"20MB":20,"24MB":24,"32MB":32,"64MB":64,"128MB":128};break;default:o.chunks_list=u.CHUNK_SIZES_LIST}else c.error(s.t('Your license status is invalid. Only "Local" and "JetStorage" destinations can be added.'))},o.ok=function(){if(!o.loading){o.loading=!0;let a=r.saveParams(o.saveData,o.details);i.manageDestination({data:a,success:function(e,t){o.loading=!1,n.close(a),c.success(t)},failed:function(e){o.loading=!1,c.error(e)}})}},o.cancel=function(){n.dismiss("cancel")},l?(o.loaded=!1,i.getDestination({data:{[u.ID_FIELD]:l},success:function(e){o.details=e,o.saveData=r.duplicateObject(o.details),o.saveData.options||(o.saveData.options={});e=o.saveData.type;o.destinationTypes[e]?(o.selectedDestinationType=o.destinationTypes[e].display,o.destinationTemplate=o.includePath("destinations/"+e),o.saveData.type=e):"Local"===o.saveData.type&&(o.selectedDestinationType="Local",o.destinationTemplate=""),o.loaded=!0},failed:function(e){c.error(e),o.loading=!1,o.loaded=!0}})):(o.loaded=!0,o.fetchDestinationDetails=function(e){i.getDestination({data:{type:e},success:function(e){o.destinationDetails=e,o.loaded=!0},failed:function(e){c.error(e)}})})}])}),define("controllers/modal/manageBackupJob",["app"],function(e){e.controller("manageBackupJob",["$uibModalInstance","$scope","$timeout","$q","api","meta","lang","jobID","util","alert","consts",function(n,o,e,t,i,a,s,l,r,c,u){o.excludes=[],o.database_excludes=[],o.destinations=[],o.schedules=[],o.formErrors=[],o.details={},o.databaseTables=[],o.excludeFilesInput="",o.loading=!0,o.saving=!1,o.jobID=l,o.saveData={[u.MANAGE_BACKUP_JOB_NAME]:"",[u.MANAGE_BACKUP_JOB_TYPE]:u.MANAGE_BACKUP_JOB_TYPE_ACCOUNT,[u.MANAGE_BACKUP_JOB_CONTAINS]:u.BACKUP_ACCOUNT_CONTAINS_FULL,[u.MANAGE_BACKUP_JOB_CONTAINS_FILES_TEXT]:!0,[u.MANAGE_BACKUP_JOB_CONTAINS_DATABASE_TEXT]:!0,[u.MANAGE_BACKUP_JOB_NEXT_RUN]:0,[u.MANAGE_BACKUP_JOB_LAST_RUN]:0,[u.MANAGE_BACKUP_JOB_ENABLED]:!0,[u.MANAGE_BACKUP_JOB_HIDDEN]:!1,[u.MANAGE_BACKUP_JOB_UNIQUE_ID]:null,[u.MANAGE_BACKUP_JOB_DESTINATIONS]:[],[u.MANAGE_BACKUP_JOB_EXCLUDES]:[],[u.MANAGE_BACKUP_JOB_SCHEDULES]:[],[u.MANAGE_BACKUP_JOB_EXCLUDE_DATABASES]:[],[u.MANAGE_BACKUP_JOB_SCHEDULE_TIME]:null,[u.MANAGE_BACKUP_JOB_JOB_MONITOR]:0},o.toggleBackupOption=function(){let e=0;o.saveData.contains_files&&(e|=u.MANAGE_BACKUP_JOB_CONTAINS_HOMEDIR),o.saveData.contains_database&&(e|=u.MANAGE_BACKUP_JOB_CONTAINS_DATABASE),o.saveData[u.MANAGE_BACKUP_JOB_CONTAINS]=e,o.saveData.is_files_excluded||(o.saveData[u.MANAGE_BACKUP_JOB_EXCLUDES]=[],o.excludeFilesInput=""),o.saveData.is_tables_excluded||(o.saveData[u.MANAGE_BACKUP_JOB_EXCLUDE_DATABASES]=[],o.database_excludes=[])},o.ok=function(){if(!o.saving){o.saving=!0,o.saveData[u.MANAGE_BACKUP_JOB_EXCLUDE_DATABASES]=o.database_excludes.map(function(e){return e.name}),o.saveData[u.MANAGE_BACKUP_JOB_EXCLUDES]=o.excludeFilesInput.split("\n").map(e=>e.trim()).filter(e=>0<e.length);let a=r.saveParams(o.saveData,o.details);a[u.MANAGE_BACKUP_JOB_JOB_MONITOR]=a[u.MANAGE_BACKUP_JOB_JOB_MONITOR]||0,i.manageBackupJob({data:a,success:function(e,t){o.saving=!1,n.close(a),c.success(t)},failed:function(e){c.error(e),o.saving=!1}})}},o.cancel=function(){o.formErrors=[],n.dismiss("cancel")},o.toggleDestination=function(e){var t;o.isDestinationChecked(e)?(t=o.saveData[u.MANAGE_BACKUP_JOB_DESTINATIONS].indexOf(e),o.saveData[u.MANAGE_BACKUP_JOB_DESTINATIONS].splice(t,1)):o.saveData[u.MANAGE_BACKUP_JOB_DESTINATIONS].push(e)},o.isDestinationChecked=function(e){return 0<=o.saveData[u.MANAGE_BACKUP_JOB_DESTINATIONS].indexOf(e)},o.toggleSchedule=function(t){var e;o.schedules.forEach(function(e){e.type===t.type&&e._id!==t._id&&(e.selected=!1,0<=(e=o.getScheduleIndex(e._id)))&&o.saveData[u.MANAGE_BACKUP_JOB_SCHEDULES].splice(e,1)}),o.isScheduleChecked(t._id)?0<=(e=o.getScheduleIndex(t._id))&&o.saveData[u.MANAGE_BACKUP_JOB_SCHEDULES].splice(e,1):(o.saveData[u.MANAGE_BACKUP_JOB_SCHEDULES].push({[u.ID_FIELD]:t._id,retain:void 0!==t.retain?t.retain:0}),t.selected=!0)},o.getScheduleIndex=function(e){for(var t=0;t<o.saveData[u.MANAGE_BACKUP_JOB_SCHEDULES].length;t++)if(o.saveData[u.MANAGE_BACKUP_JOB_SCHEDULES][t]._id==e)return t;return-1},o.isScheduleChecked=function(e){return 0<=o.getScheduleIndex(e)},o.updateScheduleRetain=function(e){var t;o.isScheduleChecked(e._id)&&(t=o.getScheduleIndex(e._id),o.saveData[u.MANAGE_BACKUP_JOB_SCHEDULES][t].retain=e.retain)},o.loadDestinations=function(){return new Promise((a,t)=>{i.listDestinations({success:function(e){o.destinations=e.destinations;for(var t=0;t<o.destinations.length;t++)o.destinations[t].selected=o.isDestinationChecked(o.destinations[t]._id);a()},failed:function(e){c.error(e),t()}})})},o.loadSchedules=function(){return new Promise((n,t)=>{i.listSchedules({success:function(e){o.schedules=e.schedules.filter(function(e){return!(6===e.type&&e.backup_id&&e.backup_id===l)});for(var t=0;t<o.schedules.length;t++){var a=o.getScheduleIndex(o.schedules[t]._id);o.schedules[t].selected=o.isScheduleChecked(o.schedules[t]._id),0<=a&&(o.schedules[t].retain=o.details[u.MANAGE_BACKUP_JOB_SCHEDULES][a].retain)}n()},failed:function(e){c.error(e),t()}})})},o.changeRetain=function(e,t){t=(e.retain||0)+t;0<=t&&t<=999&&(e.retain=t,o.updateScheduleRetain(e))},o.listDatabaseTables=function(){return new Promise((t,a)=>{i.listDatabaseTables({success:function(e){e=e.tables||[];o.databaseTables=e.map(function(e){return{name:e}}),o.database_excludes=o.database_excludes.map(function(t){return o.databaseTables.find(function(e){return e.name===t})}).filter(Boolean),t()},failed:function(e){c.error(e),a()}})})},o.loadAllData=function(){o.loading=!0,moment.updateLocale("en",{longDateFormat:{LT:"HH:mm"}}),o.loadDestinations().then(()=>o.loadSchedules()).then(()=>o.listDatabaseTables()).finally(()=>{o.loading=!1}).catch(()=>{o.loading=!1,c.error(s.t("Failed to load all required data."))})},l?(o.loading=!0,i.getBackupJob({data:{[u.ID_FIELD]:l},success:function(e){o.details=e,o.saveData=r.duplicateObject(o.details);e=o.saveData[u.MANAGE_BACKUP_JOB_CONTAINS];o.saveData.contains_files=0!=(e&u.MANAGE_BACKUP_JOB_CONTAINS_HOMEDIR),o.saveData.contains_database=0!=(e&u.MANAGE_BACKUP_JOB_CONTAINS_DATABASE),o.database_excludes=o.saveData[u.MANAGE_BACKUP_JOB_EXCLUDE_DATABASES]||[],o.saveData.is_tables_excluded=0<o.database_excludes.length,o.saveData.is_files_excluded=0<(o.saveData[u.MANAGE_BACKUP_JOB_EXCLUDES]||[]).length,o.saveData.job_monitor=o.saveData.job_monitor||0,o.excludeFilesInput=(o.saveData[u.MANAGE_BACKUP_JOB_EXCLUDES]||[]).join("\n"),o.loadAllData()},failed:function(e){c.error(e),o.loading=!1}})):o.loadAllData()}])}),define("controllers/modal/manageSchedule",["app"],function(e){e.controller("manageSchedule",["$uibModalInstance","$scope","$timeout","api","meta","lang","scheduleID","util","alert","consts",function(n,o,e,t,a,i,s,l,r,c){o.formErrors=[],o.details={},o.loading=!0,o.scheduleID=s,o.saveData={[c.MANAGE_SCHEDULE_NAME]:"",[c.MANAGE_SCHEDULE_TYPE]:c.SCHEDULE_TYPE_DAILY,[c.MANAGE_SCHEDULE_INTERVALS]:null,[c.MANAGE_SCHEDULE_BACKUP_ID]:null},o.backupJobs=[],o.$watch("saveData.type",function(e){Number(e)===c.SCHEDULE_TYPE_AFTER_JOB_DONE&&t.listBackupJobs({success:function(e){o.backupJobs=e.jobs.filter(e=>e.enabled&&!e.hidden)},failed:function(e){r.error(e)}})}),o.scheduleTypes=[{value:c.SCHEDULE_TYPE_HOURLY,label:i.t("Hourly")},{value:c.SCHEDULE_TYPE_DAILY,label:i.t("Daily")},{value:c.SCHEDULE_TYPE_WEEKLY,label:i.t("Weekly")},{value:c.SCHEDULE_TYPE_MONTHLY,label:i.t("Monthly")},{value:c.SCHEDULE_TYPE_AFTER_JOB_DONE,label:i.t("After Backup Job Done")}],o.getIntervalsLabel=function(){return o.saveData.type===c.SCHEDULE_TYPE_AFTER_JOB_DONE?i.t("Job Selection"):i.t("Intervals")},o.initializeIntervals=function(){o.saveData.type===c.SCHEDULE_TYPE_DAILY||o.saveData.type===c.SCHEDULE_TYPE_MONTHLY?o.saveData[c.MANAGE_SCHEDULE_INTERVALS]=[]:o.saveData[c.MANAGE_SCHEDULE_INTERVALS]=null},o.hourlyIntervals=[{value:1,label:i.t("Every Hour")},{value:2,label:i.t("Every 2 Hours")},{value:3,label:i.t("Every 3 Hours")},{value:4,label:i.t("Every 4 Hours")},{value:6,label:i.t("Every 6 Hours")},{value:8,label:i.t("Every 8 Hours")},{value:12,label:i.t("Every 12 Hours")}],o.dailyIntervals=[{value:1,label:i.t("Sunday")},{value:2,label:i.t("Monday")},{value:3,label:i.t("Tuesday")},{value:4,label:i.t("Wednesday")},{value:5,label:i.t("Thursday")},{value:6,label:i.t("Friday")},{value:7,label:i.t("Saturday")}],o.weeklyIntervals=[{value:0,label:i.t("Sunday")},{value:1,label:i.t("Monday")},{value:2,label:i.t("Tuesday")},{value:3,label:i.t("Wednesday")},{value:4,label:i.t("Thursday")},{value:5,label:i.t("Friday")},{value:6,label:i.t("Saturday")}],o.monthlyIntervals=[{value:1,label:i.t("1st of month")},{value:7,label:i.t("7th of month")},{value:14,label:i.t("14th of month")},{value:21,label:i.t("21st of month")},{value:28,label:i.t("28th of month")}],o.initializeIntervals=function(){2===o.saveData.type||4===o.saveData.type?o.saveData[c.MANAGE_SCHEDULE_INTERVALS]=[]:o.saveData[c.MANAGE_SCHEDULE_INTERVALS]=null},o.toggleIntervalSelection=function(e,t){Array.isArray(o.saveData[c.MANAGE_SCHEDULE_INTERVALS])||(o.saveData[c.MANAGE_SCHEDULE_INTERVALS]=[]);var a=o.saveData[c.MANAGE_SCHEDULE_INTERVALS];t?a.includes(e)||a.push(e):-1<(t=a.indexOf(e))&&a.splice(t,1)},o.ok=function(){if(!o.loading){o.loading=!0;let a=l.saveParams(o.saveData,o.details);t.manageSchedule({data:a,success:function(e,t){o.loading=!1,n.close(a),r.success(t)},failed:function(e){r.error(e),o.loading=!1}})}},o.cancel=function(){o.formErrors=[],n.dismiss("cancel")},s?t.getSchedule({data:{[c.ID_FIELD]:s},success:function(e){o.details=e,o.saveData=l.duplicateObject(o.details),o.loading=!1},failed:function(e){r.error(e),o.loading=!1}}):o.loading=!1}])}),define("controllers/modal/importBackup",["app"],function(e){e.controller("importBackup",["$uibModalInstance","$scope","$timeout","api","alert","consts","$location",function(a,n,e,t,o,i,s){n.clearFile=function(){n.progress=0,n.file={name:"",size:0,type:""}},n.progress=0,n.uploading=!1,n.abort=!1,n.clearFile(),n.ok=function(){var e;n.uploading||(n.uploading=!0,e={[i.QUEUE_TYPE_FIELD]:i.QUEUE_TYPE_RESTORE,file:n.file.object,restoreOptions:i.RESTORE_DATABASE_ENTIRE|i.RESTORE_FILES_ENTIRE,selectedTables:[],folderList:[]},t.addToQueue({data:e,progress:function(e){n.progress=e},cancel:function(){return n.abort},success:function(e,t){o.success(t),n.uploading=!1,a.close(),s.path("/queue")},failed:function(e){o.error(e),n.uploading=!1}}))},n.cancel=function(){n.abort=!0,a.dismiss()}}])}),define("controllers/modal/restoreBackup",["app"],function(e){e.controller("restoreBackup",["$rootScope","$uibModalInstance","$scope","$timeout","api","meta","lang","backupObject","consts","alert","popup",function(e,a,n,t,o,i,s,l,r,c,u){n.consts=r,n.backup=l,n.multisite=l.params.multisite||[],n.databaseTables=[],n.selectedDestination=null,n.files={},n.errors={database:!1,homedir:!1},n.loading=!1,n.loadingTables=!0,n.backup.homedir_options=n.backup.homedir_options||{},n.multisite_main_site_id=e.configuration.env.multisite_main_site_id,n.selectedSiteID=n.multisite_main_site_id,n.containsDatabase=()=>0!=(n.backup.contains&r.BACKUP_ACCOUNT_CONTAINS_DATABASE),n.containsHomeDir=()=>0!=(n.backup.contains&r.BACKUP_ACCOUNT_CONTAINS_HOMEDIR),n.selectedDatabaseOption=n.containsDatabase()?String(r.RESTORE_DATABASE_ENTIRE):String(r.RESTORE_DATABASE_SKIP),n.selectedHomedirOption=n.containsHomeDir()?String(r.RESTORE_FILES_ENTIRE):String(r.RESTORE_FILES_SKIP),n.selectedTables=[],n.folderList="",n.folderListLabel=s.t("File/Folders to exclude"),n.selectedSiteID=n.multisite.length?1:null,n.initialDatabaseTables=[],n.onMultisiteChange=function(e){n.selectedSiteID=e?parseInt(e):1;e=n.multisite.find(e=>e.id===n.selectedSiteID);1===n.selectedSiteID?(n.databaseTables=angular.copy(n.initialDatabaseTables),n.selectedTables=[],n.selectedTablesReadOnly=!1):(n.databaseTables.db_tables=e?e.database_tables:[],n.selectedTables=n.containsDatabase()?[...n.databaseTables.db_tables]:[],n.selectedTablesReadOnly=!0),n.containsDatabase()||(n.selectedTables=[]),n.folderList="",n.selectedSiteID===n.multisite_main_site_id?(Object.assign(n,{selectedDatabaseOption:String(r.RESTORE_DATABASE_ENTIRE),databaseOptionReadOnly:!1,selectedTablesReadOnly:!1,fileOptionReadOnly:!1,selectedHomedirOption:String(r.RESTORE_FILES_ENTIRE),folderListLabel:s.t("File/Folders to exclude")}),n.backup.homedir_options&&delete n.backup.homedir_options[r.RESTORE_FILES_INCLUDE]):(Object.assign(n,{selectedDatabaseOption:String(r.RESTORE_DATABASE_INCLUDE),databaseOptionReadOnly:!0,selectedTables:n.containsDatabase()?[...n.databaseTables.db_tables]:[],selectedTablesReadOnly:!0,fileOptionReadOnly:!0,folderListLabel:s.t("Restore only these files/folders"),folderList:n.containsHomeDir()?[`wp-content/blogs.dir/${n.selectedSiteID}/files/*`,`wp-content/uploads/sites/${n.selectedSiteID}/*`,`wp-content/uploads/${n.selectedSiteID}/*`,`wp-content/${n.selectedSiteID}/*`].join("\n"):""}),n.backup.homedir_options[r.RESTORE_FILES_INCLUDE]=s.t("Restore Only Listed Folders"),n.selectedHomedirOption="",t(()=>{n.selectedHomedirOption=String(r.RESTORE_FILES_INCLUDE)}))},n.selectDestination=function(e){n.selectedDestination=e,n.backup._id=e.snap_id,n.loading=!0,o.getDatabaseTables({data:{[r.ID_FIELD]:n.backup._id},success:function(e){n.databaseTables=e,n.initialDatabaseTables=angular.copy(e),n.loading=n.loadingTables=!1},failed:function(e){console.error("Error fetching database tables:",e),c.error(e),n.loading=!1}})},1===n.backup.destinations.length&&n.selectDestination(n.backup.destinations[0]),n.backup.database_options={[r.RESTORE_DATABASE_ENTIRE]:s.t("Entire Database"),[r.RESTORE_DATABASE_EXCLUDE]:s.t("Exclude Selected Tables"),[r.RESTORE_DATABASE_INCLUDE]:s.t("Restore Only Selected Tables"),[r.RESTORE_DATABASE_SKIP]:s.t("Do Not Restore Database")},n.backup.engine===r.ENGINE_JETBACKUP_LINUX&&(n.backup.database_options={[r.RESTORE_DATABASE_ENTIRE]:s.t("Entire Database"),[r.RESTORE_DATABASE_SKIP]:s.t("Do Not Restore Database")}),n.backup.homedir_options={[r.RESTORE_FILES_ENTIRE]:s.t("Entire Backup"),[r.RESTORE_FILES_EXCLUDE]:s.t("Exclude Listed Folders"),[r.RESTORE_FILES_SKIP]:s.t("Do Not Restore Files")},n.backup.engine===r.ENGINE_JETBACKUP_LINUX&&(n.backup.homedir_options={[r.RESTORE_FILES_ENTIRE]:s.t("Entire Backup"),[r.RESTORE_FILES_INCLUDE]:s.t("Restore Only Selected Files/Folders"),[r.RESTORE_FILES_SKIP]:s.t("Do Not Restore Files")}),n.validateFileManagerPath=function(t){n.backup.engine===r.ENGINE_JETBACKUP_LINUX&&parseInt(n.selectedHomedirOption)===r.RESTORE_FILES_ENTIRE?o.fileManager({data:{_id:n.backup._id,location:"/"},success:function(){t(!0)},failed:function(e){console.error("File verification failed:",e),c.error(s.t("Failed to verify file access: ")+e),t(!1)}}):t(!0)},n.isValidRestoreOptions=function(){var e=!n.selectedDatabaseOption||n.selectedDatabaseOption===r.RESTORE_DATABASE_SKIP,t=!n.selectedHomedirOption||n.selectedHomedirOption===r.RESTORE_FILES_SKIP;return!(e&&t)},n.ok=function(){n.errors.database=!n.selectedDatabaseOption,n.errors.homedir=!n.selectedHomedirOption,n.isValidRestoreOptions()&&n.validateFileManagerPath(function(e){e&&(n.loading=!0,e=parseInt(n.selectedDatabaseOption)|parseInt(n.selectedHomedirOption),e={[r.QUEUE_TYPE_FIELD]:r.QUEUE_TYPE_RESTORE,[r.ID_FIELD]:n.backup._id,restoreOptions:e,selectedTables:n.selectedTables||[],folderList:Array.isArray(n.folderList)?n.folderList:n.folderList.split(/\r?\n/).filter(e=>""!==e.trim()),fileManager:n.files},o.addToQueue({data:e,success:function(e,t){n.loading=!1,c.success(t),a.close(e)},failed:function(e){c.error(e),n.loading=!1}}))})},n.isFileBrowseDisabled=!1,n.fileBrowse=function(e){n.isFileBrowseDisabled=!0,u.open({size:"xl",template:"modal/fileManager",controller:"fileManager",scope:n,resolve:{files:()=>n.files,backup:()=>e}}).result.then(function(e){n.files=e,n.isFileBrowseDisabled=!1},function(){n.isFileBrowseDisabled=!1})},n.cancel=function(){a.dismiss()}}])}),define("controllers/modal/exportBackup",["app"],function(e){e.controller("exportBackup",["$uibModalInstance","$scope","$timeout","api","meta","lang","backupObject","icons","consts","alert",function(a,n,e,t,o,i,s,l,r,c){n.backup=s,n.icons=l,n.selectedPanel=null,n.selectedDestination=null,n.selectDestination=function(e){n.selectedDestination=e},n.ok=function(){var e=n.backup.destinations.find(e=>e.id===n.selectedDestination)||n.backup.destinations[0],e={[r.ID_FIELD]:e.snap_id,[r.QUEUE_TYPE_FIELD]:r.QUEUE_TYPE_EXPORT,[r.PANEL_TYPE_FIELD]:n.selectedPanel};t.addToQueue({data:e,success:function(e,t){n.loading=!1,c.success(t),a.close(e)},failed:function(e){c.error(e),n.loading=!1}})},n.cancel=function(){a.dismiss()}}])}),define("controllers/modal/editBackupNotes",["app"],function(e){e.controller("editBackupNotes",["$uibModalInstance","$scope","$timeout","api","meta","lang","backupObject","consts","util","alert",function(a,n,e,t,o,i,s,l,r,c){n.backupObject=s,n.selectDestination=function(t){e(()=>{n.selectedDestination=t;var e=n.backupObject.destinations.find(e=>e.id===t);n.backupObject.notes=e&&e.notes||""})},n.ok=function(){var e;n.loading||(n.loading=!0,e=n.backupObject.destinations.find(e=>e.id===n.selectedDestination)||n.backupObject.destinations[0],e={[l.ID_FIELD]:e.snap_id,[l.BACKUP_JOB_NOTES]:n.backupObject.notes},t.editBackupNotes({data:e,success:function(e,t){n.loading=!1,c.success(t),a.close(e)},failed:function(e){c.error(e),n.loading=!1}}))},n.cancel=function(){a.dismiss()}}])}),define("controllers/modal/lockBackup",["app"],function(e){e.controller("lockBackup",["$uibModalInstance","$scope","$timeout","api","meta","lang","backupObject","consts","alert",function(a,n,e,t,o,i,s,l,r){n.backup=s,n.selectedDestination=null,n.currentLockStatus=null,n.loading=!1,1===n.backup.destinations.length&&(s=n.backup.destinations[0],n.selectedDestination=s.id,n.currentLockStatus=1===s.locked),n.updateLockStatus=function(e){n.selectedDestination=e.id,n.currentLockStatus=1===e.locked},n.ok=function(){var e;!n.loading&&n.selectedDestination&&(n.loading=!0,e=n.backup.destinations.find(e=>e.id===n.selectedDestination),e={[l.ID_FIELD]:e.snap_id},t.lockSnapshot({data:e,success:function(e,t){r.success(t),n.loading=!1,n.fetch(),a.dismiss()},failed:function(e){r.error(e),n.loading=!1}}))},n.cancel=function(){a.dismiss()}}])}),define("controllers/modal/deleteBackup",["app"],function(e){e.controller("deleteBackup",["$uibModalInstance","$scope","$timeout","api","meta","lang","backupObject","consts","alert",function(a,n,e,t,o,i,s,l,r){n.backup=s,n.selectedDestination=null,n.currentDeletionStatus=null,n.loading=!1,1===n.backup.destinations.length&&(s=n.backup.destinations[0],n.selectedDestination=s.id,n.currentDeletionStatus=s.deleted),n.updateDeletionStatus=function(e){n.selectedDestination=e.id,n.currentDeletionStatus=e.deleted},n.ok=function(){var e;!n.loading&&n.selectedDestination&&(n.loading=!0,e=n.backup.destinations.find(e=>e.id===n.selectedDestination),e={[l.ID_FIELD]:e.snap_id},t.deleteSnapshot({data:e,success:function(e,t){r.success(t),n.loading=!1,n.fetch(),a.dismiss()},failed:function(e){r.error(e),n.loading=!1}}))},n.cancel=function(){a.dismiss()}}])}),define("controllers/modal/showExtractedPath",["app"],function(e){e.controller("showExtractedPath",["$uibModalInstance","$scope","extractPath","lang","alert",function(e,t,a,n,o){t.extractPath=a,t.copyToClipboard=function(){var e=document.getElementById("extractedPathInput");e&&(e.select(),e.setSelectionRange(0,99999),navigator.clipboard.writeText(e.value).then(()=>{o.success(n.t("Path copied to clipboard!"))}).catch(()=>{o.error(n.t("Failed to copy the path."))}))},t.cancel=function(){e.dismiss()}}])}),define("controllers/modal/callSupport",["app"],function(e){e.controller("callSupport",["$uibModalInstance","$scope","$timeout","api","alert","consts",function(e,a,t,n,o,i){a.showChatBot=!1,a.showSupportUser=!1,a.userDetails={},a.openChatBot=function(){a.showChatBot=!0,a.showSupportUser=!1,a.loading=!1},a.generateSupportUser=function(){a.userDetails.username?(a.showSupportUser=!0,a.showChatBot=!1):(a.showSupportUser=!0,a.showChatBot=!1,a.loading=!0,n.createSupportUser({success:function(e,t){a.loading=!1,a.userDetails=e,o.success(t)},failed:function(e){o.error(e),a.loading=!1}}))},a.copySupportUser=function(){var e=`User: ${a.userDetails.username}
Email: ${a.userDetails.email}
Password: ${a.userDetails.password}
WordPress Admin URL: `+a.userDetails.wordpress_admin_url;navigator.clipboard.writeText(e).then(function(){o.success("Support user details copied to clipboard!")})},a.cancel=function(){a.abort=!0,e.dismiss()}}])}),define("controllers/modal/viewLog",["app"],function(e){e.controller("viewLog",["$uibModalInstance","$scope","queueId","api","lang","alert","consts",function(e,t,a,n,o,i,s){t.loading=!0,t.content="",t.size="",t.path="",n.getLog({data:{queue_item_id:a,content:1},success:function(e){t.content=e.content,t.size=e.size,t.path=e.path,t.loading=!1},failed:function(){t.loading=!1,i.error(o.t("Failed to load log.")),e.dismiss()}}),t.cancel=function(){e.dismiss()}}])}),define("controllers/destinations/FTP",["app"],function(e){e.controller("destinationFTP",["$rootScope","$scope","consts",function(e,t,a){e.$emit("menuItem","Destinations"),t.saveData.options=Object.assign({path:a.DESTINATIONS_DEFAULT_FOLDER,server:"",port:a.DESTINATIONS_DEFAULT_PORT_FTP,username:"",password:"",ssl:!1,ignore_self_signed:!0,passive_mode:!0,timeout:a.DESTINATIONS_DEFAULT_TIMEOUT,retries:a.DESTINATIONS_DEFAULT_RETRIES,prefer_ip:4},t.saveData.options)}])}),define("controllers/destinations/SFTP",["app"],function(e){e.controller("destinationSFTP",["$rootScope","$scope","consts",function(e,t,a){e.$emit("menuItem","Destinations"),t.saveData.options=Object.assign({path:a.DESTINATIONS_DEFAULT_FOLDER,timeout:a.DESTINATIONS_DEFAULT_TIMEOUT,retries:a.DESTINATIONS_DEFAULT_RETRIES,host:"",privatekey:"",passphrase:"",port:a.DESTINATIONS_DEFAULT_PORT_SSH,username:"",password:""},t.saveData.options)}])}),define("controllers/destinations/S3",["app"],function(e){e.controller("destinationS3",["$rootScope","$scope","$location","$timeout","$interval","api","lang","consts",function(e,a,t,n,o,i,s,l){e.$emit("menuItem","Destinations"),a.saveData.options=Object.assign({path:l.DESTINATIONS_DEFAULT_FOLDER,timeout:l.DESTINATIONS_DEFAULT_TIMEOUT,retries:l.DESTINATIONS_DEFAULT_RETRIES,access_key:"",secret_key:"",bucket:"",region:"",verifyssl:!0,chunk_size:5,keepalive_timeout:60,keepalive_requests:100,verifyupload:!1,extrafields:{}},a.saveData.options),a.selected_vendor="",a.selected_region="0",a.changeVendor=function(e,t){t&&(a.saveData.options.region="",a.selected_region="0"),a.selected_vendor!==e&&(a.selected_vendor=e,a.saveData.options.selected_vendor=e,a.saveData.options.extrafields={},"custom"===e?a.saveData.options.endpoint="":(t=a.vendors[e])&&(a.saveData.options.endpoint=t.endpoint||"",t.extrafields.forEach(e=>{a.saveData.options.extrafields[e.name]||(a.saveData.options.extrafields[e.name]=e.default||"")})))},a.changeRegion=function(){var e=a.vendors[a.selected_vendor].regions;e.length?a.saveData.options.region=e[a.selected_region].value:(a.saveData.options.region="",a.selected_region="0")},a.vendors={amazon:{name:"AmazonS3",endpoint:"s3.{region}.amazonaws.com",extrafields:[],regions:[{name:s.t("Custom Region"),value:""},{name:"North Virginia, United States East (us-east-1)",group:"North America",value:"us-east-1"},{name:"Ohio, United States East (us-east-2)",group:"North America",value:"us-east-2"},{name:"Oregon, United States West (us-west-2)",group:"North America",value:"us-west-2"},{name:"North California, United States West (us-west-1)",group:"North America",value:"us-west-1"},{name:"Canada Central (ca-central-1)",group:"North America",value:"ca-central-1"},{name:"São Paulo, Brazil (sa-east-1)",group:"South America",value:"sa-east-1"},{name:"Frankfurt, Germany (eu-central-1)",group:"Europe",value:"eu-central-1"},{name:"Ireland (eu-west-1)",group:"Europe",value:"eu-west-1"},{name:"London, United Kingdom (eu-west-2)",group:"Europe",value:"eu-west-2"},{name:"Paris, France (eu-west-3)",group:"Europe",value:"eu-west-3"},{name:"Stockholm, Sweden (eu-north-1)",group:"Europe",value:"eu-north-1"},{name:"Singapore (ap-southeast-1)",group:"Asia Pacific",value:"ap-southeast-1"},{name:"Sydney, Australia (ap-southeast-2)",group:"Australia",value:"ap-southeast-2"},{name:"Tokyo, Japan (ap-northeast-1)",group:"Asia Pacific",value:"ap-northeast-1"},{name:"Seoul, South Korea (ap-northeast-2)",group:"Asia Pacific",value:"ap-northeast-2"},{name:"Mumbai, India (ap-south-1)",group:"Asia Pacific",value:"ap-south-1"}]},googlecloud:{name:"Google Cloud",endpoint:"storage.googleapis.com",extrafields:[],regions:!1},oracle:{name:"Oracle Cloud",endpoint:"{namespace}.compat.objectstorage.{region}.oraclecloud.com",extrafields:[{label:"Namespace",description:"",name:"namespace"}],regions:[{name:s.t("Custom Region"),value:""},{name:"Amsterdam, Netherlands Northwest (eu-amsterdam-1)",group:"Europe",value:"eu-amsterdam-1"},{name:"Sydney, Australia East (ap-sydney-1)",group:"Australia",value:"ap-sydney-1"},{name:"Melbourne, Australia Southeast (ap-melbourne-1)",group:"Australia",value:"ap-melbourne-1"},{name:"Sao Paulo, Brazil East (sa-saopaulo-1)",group:"South America",value:"sa-saopaulo-1"},{name:"Montreal, Canada Southeast (ca-montreal-1)",group:"North America",value:"ca-montreal-1"},{name:"Toronto, Canada Southeast (ca-toronto-1)",group:"North America",value:"ca-toronto-1"},{name:"Santiago, Chile Central (sa-santiago-1)",group:"South America",value:"sa-santiago-1"},{name:"Frankfurt, Germany Central (eu-frankfurt-1)",group:"Europe",value:"eu-frankfurt-1"},{name:"Hyderabad, India South (ap-hyderabad-1)",group:"Asia Pacific",value:"ap-hyderabad-1"},{name:"Mumbai, India West (ap-mumbai-1)",group:"Asia Pacific",value:"ap-mumbai-1"},{name:"Osaka, Japan Central (ap-osaka-1)",group:"Asia Pacific",value:"ap-osaka-1"},{name:"Tokyo, Japan East (ap-tokyo-1)",group:"Asia Pacific",value:"ap-tokyo-1"},{name:"Jeddah, Saudi Arabia West (me-jeddah-1)",group:"Middle East",value:"me-jeddah-1"},{name:"Seoul, South Korea Central (ap-seoul-1)",group:"Asia Pacific",value:"ap-seoul-1"},{name:"Chuncheon, South Korea North (ap-chuncheon-1)",group:"Asia Pacific",value:"ap-chuncheon-1"},{name:"Zurich, Switzerland North (eu-zurich-1)",group:"Europe",value:"eu-zurich-1"},{name:"Dubai, UAE East (me-dubai-1)",group:"Middle East",value:"me-dubai-1"},{name:"London, United Kingdom South (uk-london-1)",group:"Europe",value:"uk-london-1"},{name:"Newport, United Kingdom West (uk-cardiff-1)",group:"Europe",value:"uk-cardiff-1"},{name:"Ashburn, United States East (us-ashburn-1)",group:"North America",value:"us-ashburn-1"},{name:"Phoenix, United States West (us-phoenix-1)",group:"North America",value:"us-phoenix-1"},{name:"San Jose, United States West (us-sanjose-1)",group:"North America",value:"us-sanjose-1"}]},wasabi:{name:"Wasabi",endpoint:"s3.{region}.wasabisys.com",extrafields:[],regions:[{name:s.t("Custom Region"),value:""},{name:"North Virginia 1, United States East (us-east-1)",group:"North America",value:"us-east-1"},{name:"North Virginia 2, United States East (us-east-2)",group:"North America",value:"us-east-2"},{name:"Oregon, United States West (us-west-1)",group:"North America",value:"us-west-1"},{name:"Texas, United States Central (us-central-1)",group:"North America",value:"us-central-1"},{name:"Toronto, Canada (ca-central-1)",group:"North America",value:"ca-central-1"},{name:"Amsterdam, Netherlands (eu-central-1)",group:"Europe",value:"eu-central-1"},{name:"Frankfurt, Germany (eu-central-2)",group:"Europe",value:"eu-central-2"},{name:"London, England (eu-west-1)",group:"Europe",value:"eu-west-1"},{name:"Paris, France (eu-west-2)",group:"Europe",value:"eu-west-2"},{name:"Milan, Italy (eu-south-1)",group:"Europe",value:"eu-south-1"},{name:"Tokyo, Japan (ap-northeast-1)",group:"Asia Pacific",value:"ap-northeast-1"},{name:"Osaka, Japan (ap-northeast-2)",group:"Asia Pacific",value:"ap-northeast-2"},{name:"Singapore (ap-southeast-1)",group:"Asia Pacific",value:"ap-southeast-1"},{name:"Sydney, Australia (ap-southeast-2)",group:"Australia",value:"ap-southeast-2"}]},digitalocean:{name:"DigitalOcean Spaces",endpoint:"{region}.digitaloceanspaces.com",extrafields:[],regions:[{name:s.t("Custom Region"),value:""},{name:"Frankfurt, Germany (fra1)",group:"Europe",value:"fra1"},{name:"Amsterdam, Netherlands (ams3)",group:"Europe",value:"ams3"},{name:"New York, United States East (nyc3)",group:"North America",value:"nyc3"},{name:"San Fransisco 2, United States West (sfo2)",group:"North America",value:"sfo2"},{name:"San Fransisco 3, United States West (sfo3)",group:"North America",value:"sfo3"},{name:"Singapore (sgp1)",group:"Asia Pacific",value:"sgp1"},{name:"Bangalore, India (blr1)",group:"Asia Pacific",value:"blr1"},{name:"Sydney, Australia (syd1)",group:"Australia",value:"syd1"}]},backblaze:{name:"BackBlaze",endpoint:"s3.{region}.backblazeb2.com",extrafields:[],regions:[{name:s.t("Custom Region"),value:""},{name:"Europe Central (003) (eu-central-003)",group:"Europe",value:"eu-central-003"},{name:"United States West (000) (us-west-000)",group:"North America",value:"us-west-000"},{name:"United States West (001) (us-west-001)",group:"North America",value:"us-west-001"},{name:"United States West (002) (us-west-002)",group:"North America",value:"us-west-002"}]},ibm:{name:"IBM",endpoint:"s3.{region}.cloud-object-storage.appdomain.cloud",extrafields:[],regions:[{name:s.t("Custom Region"),value:""},{name:"Cross Region (us)",group:"North America",value:"us"},{name:"United States South (us-south)",group:"North America",value:"us-south"},{name:"United States East (us-east)",group:"North America",value:"us-east"},{name:"San Jose, United States (sjc04)",group:"North America",value:"sjc04"},{name:"Mexico City, Mexico (mex01)",group:"North America",value:"mex01"},{name:"Montrèal, Canada (mon01)",group:"North America",value:"mon01"},{name:"Cross Region (eu)",group:"Europe",value:"eu"},{name:"United Kingdom (eu-gb)",group:"Europe",value:"eu-gb"},{name:"Germany (eu-de)",group:"Europe",value:"eu-de"},{name:"Amsterdam, Netherlands (ams03)",group:"Europe",value:"ams03"},{name:"Milan, Italy (mil01)",group:"Europe",value:"mil01"},{name:"Paris, France (par01)",group:"Europe",value:"par01"},{name:"Oslo, Norway (osl01)",group:"Europe",value:"osl01"},{name:"Cross Region (ap)",group:"Asia Pacific",value:"ap"},{name:"Australia (au-syd)",group:"Australia",value:"au-syd"},{name:"Japan (jp-tok)",group:"Asia Pacific",value:"jp-tok"},{name:"Chennai, India (che01)",group:"Asia Pacific",value:"che01"},{name:"Hong Kong S.A.R. of the PRC (hkg02)",group:"Asia Pacific",value:"hkg02"}]},scaleway:{name:"Scaleway",endpoint:"s3.{region}.scw.cloud",extrafields:[],regions:[{name:s.t("Custom Region"),value:""},{name:"Amsterdam, Netherlands (nl-ams)",group:"Europe",value:"nl-ams"},{name:"Paris, France (fr-par)",group:"Europe",value:"fr-par"},{name:"Warsaw, Poland (pl-waw)",group:"Europe",value:"pl-waw"}]},cloudflare:{name:"CloudFlare R2",endpoint:"{accountid}.r2.cloudflarestorage.com",extrafields:[{label:s.t("Account ID"),name:"accountid",description:s.t("Please provide the account_id from the CloudFlare R2 dashboard. (e.g. https://{account_id}.r2.cloudflarestorage.com)")}],regions:!1},vultr:{name:"Vultr",endpoint:"{region}.vultrobjects.com",extrafields:[],regions:[{name:s.t("Custom Region"),value:""},{name:"New Jersey, United States East (ewr1)",group:"North America",value:"ewr1"},{name:"Silicon Valley, United States West (sjc1)",group:"North America",value:"sjc1"},{name:"Amsterdam, Netherlands Northwest (ams1)",group:"Europe",value:"ams1"},{name:"Singapore (sgp1)",group:"Asia Pacific",value:"sgp1"},{name:"Bangalore, India (blr1)",group:"Asia Pacific",value:"blr1"},{name:"Delhi NCR, India (del1)",group:"Asia Pacific",value:"del1"}]},custom:{name:s.t("Custom Vendor"),endpoint:"",extrafields:[],regions:[]}}}])}),define("controllers/destinations/JetStorage",["app"],function(e){e.controller("JetStorage",["$rootScope","$scope","$location","$timeout","$interval","api","lang","consts",function(e,t,a,n,o,i,s,l){e.$emit("menuItem","Destinations"),t.saveData.options=Object.assign({path:l.DESTINATIONS_DEFAULT_FOLDER,timeout:l.DESTINATIONS_DEFAULT_TIMEOUT,retries:l.DESTINATIONS_DEFAULT_RETRIES,access_key:"",secret_key:"",bucket:"",region:"",verifyssl:!0,chunk_size:5,keepalive_timeout:60,keepalive_requests:100,verifyupload:!1,extrafields:{}},t.saveData.options),t.vendors={jetstorage:{name:"JetStorage",endpoint:"{region}",extrafields:[],regions:[{name:"Germany (eu-central-2)",group:"Europe",value:"eu-central-2.storage.jetbackup.com"},{name:"Benelux (Belgium, Netherlands, Luxembourg - eu-west-1)",group:"Europe",value:"eu-west-1.storage.jetbackup.com"}]}},t.selected_vendor="jetstorage",t.saveData.options.selected_vendor="jetstorage",t.selected_region="0",t.changeRegion=function(){var e=t.vendors[t.selected_vendor].regions;e.length?t.saveData.options.endpoint=e[t.selected_region].value:(t.saveData.options.region="",t.selected_region="0")},0<t.vendors.jetstorage.regions.length&&(t.selected_region="0",t.saveData.options.endpoint=t.vendors.jetstorage.regions[0].value)}])}),define("controllers/destinations/GoogleDrive",["app"],function(e){e.controller("destinationGoogleDrive",["$rootScope","$scope","consts",function(e,t,a){e.$emit("menuItem","Destinations"),t.saveData.options=Object.assign({path:a.DESTINATIONS_DEFAULT_FOLDER,timeout:a.DESTINATIONS_DEFAULT_TIMEOUT,retries:a.DESTINATIONS_DEFAULT_RETRIES,pkce_challenge:"",pkce_verifier:"",access_code:""},t.saveData.options),t.openAuthentication=function(){var e=[],t=(e.push("https://www.googleapis.com/auth/drive.file"),e.push("https://www.googleapis.com/auth/userinfo.email"),[]),e=(t.push("response_type=code"),t.push("access_type=offline"),t.push("client_id=72463712983-r6mekushs9d8ugj4c5f29a84u5g4li4c.apps.googleusercontent.com"),t.push("redirect_uri=https://auth.jetbackup.com/google/"),t.push("state=state_parameter_passthrough_value"),t.push("scope="+e.join(" ")),t.push("approval_prompt=force"),[]);return e.push("height=600"),e.push("width=450"),e.push("left="+(screen.width/2-225)),e.push("top="+(screen.height/2-200)),e.push("toolbar=no"),e.push("titlebar=no"),e.push("status=no"),e.push("scrollbars=no"),e.push("resizable=yes"),e.push("menubar=no"),window.open("https://accounts.google.com/o/oauth2/auth?"+t.join("&"),"",e.join(",")),!1}}])}),define("controllers/destinations/OneDrive",["app"],function(e){e.controller("destinationOneDrive",["$rootScope","$scope","$location","$timeout","$interval","api","lang","consts",function(e,t,a,n,o,i,s,l){e.$emit("menuItem","Destinations"),t.saveData.options=Object.assign({path:l.DESTINATIONS_DEFAULT_FOLDER,timeout:l.DESTINATIONS_DEFAULT_TIMEOUT,retries:l.DESTINATIONS_DEFAULT_RETRIES,http_version:0},t.saveData.options),t.getAuthCode=function(){var e=[],t=(e.push("client_id=93e83d79-3f8d-483b-9285-ae358b83640e"),e.push("response_type=code"),e.push("redirect_uri=https://auth.jetbackup.com/microsoft/"),e.push("response_mode=query"),e.push("prompt=select_account"),e.push("scope=https://graph.microsoft.com/Files.ReadWrite+offline_access"),[]);t.push("height=528"),t.push("width=400"),t.push("toolbar=no"),t.push("titlebar=no"),t.push("status=no"),t.push("scrollbars=no"),t.push("resizable=yes"),t.push("menubar=no"),window.open("https://login.microsoftonline.com/common/oauth2/v2.0/authorize?"+e.join("&"),"",t.join(","))},t.httpversion_options=[{label:s.t("Default"),value:0},{label:"HTTP/1.1",value:1},{label:"HTTP/2",value:2}]}])}),define("controllers/destinations/DropBox",["app"],function(e){e.controller("destinationDropbox",["$rootScope","$scope","$location","$timeout","$interval","api","consts","alert",function(e,t,a,n,o,i,s,l){e.$emit("menuItem","Destinations"),t.saveData.options=Object.assign({path:s.DESTINATIONS_DEFAULT_FOLDER,timeout:s.DESTINATIONS_DEFAULT_TIMEOUT,retries:s.DESTINATIONS_DEFAULT_RETRIES},t.saveData.options),t.getAuthCode=function(){var e=[],t=(e.push("response_type=code"),e.push("token_access_type=offline"),e.push("client_id=zkkk6t8uhu9umtk"),e.push("redirect_uri=https://auth.jetbackup.com/dropbox/"),[]);return t.push("height=500"),t.push("width=650"),t.push("left="+(screen.width/2-225)),t.push("top="+(screen.height/2-250)),t.push("toolbar=no"),t.push("titlebar=no"),t.push("status=no"),t.push("scrollbars=no"),t.push("resizable=yes"),t.push("menubar=no"),window.open("https://dropbox.com/oauth2/authorize?"+e.join("&"),"",t.join(",")),!1}}])}),define("controllers/destinations/Box",["app"],function(e){e.controller("destinationBox",["$rootScope","$scope","$location","$timeout","$interval","api","consts",function(e,a,t,n,o,i,s){e.$emit("menuItem","Destinations"),a.saveData.options=Object.assign({path:s.DESTINATIONS_DEFAULT_FOLDER,timeout:s.DESTINATIONS_DEFAULT_TIMEOUT,retries:s.DESTINATIONS_DEFAULT_RETRIES},a.saveData.options),a.getRefURL=function(){return""+window.location.origin+window.location.pathname},a.getAuthCode=function(){var e=[],t=(btoa(a.getRefURL()),e.push("client_id=wvxkgyw14hdyha0wzzrphmmyd3h50lp4"),e.push("response_type=code"),e.push("redirect_uri=https://auth.jetbackup.com/box/"),e.push("state=nohash"),[]);t.push("height=528"),t.push("width=400"),t.push("toolbar=no"),t.push("titlebar=no"),t.push("status=no"),t.push("scrollbars=no"),t.push("resizable=yes"),t.push("menubar=no"),window.open("https://www.box.com/api/oauth2/authorize?"+e.join("&"),"",t.join(","))}}])}),define("controllers/destinations/pCloud",["app"],function(e){e.controller("destinationPcloud",["$rootScope","$scope","consts",function(e,t,a){e.$emit("menuItem","Destinations"),t.saveData.options=Object.assign({path:a.DESTINATIONS_DEFAULT_FOLDER,timeout:a.DESTINATIONS_DEFAULT_TIMEOUT,retries:a.DESTINATIONS_DEFAULT_RETRIES},t.saveData.options),t.getAuthCode=function(){var e=[],t=(e.push("client_id=nvbJ2u82GTh"),e.push("response_type=code"),e.push("redirect_uri=https://auth.jetbackup.com/pcloud/"),[]);t.push("height=528"),t.push("width=400"),t.push("toolbar=no"),t.push("titlebar=no"),t.push("status=no"),t.push("scrollbars=no"),t.push("resizable=yes"),t.push("menubar=no"),window.open("https://my.pcloud.com/oauth2/authorize?"+e.join("&"),"",t.join(","))}}])}),define("services/api",["app"],function(e){e.factory("api",["$rootScope","$http","$location","cfpLoadingBar","lang",function(e,t,a,n,o){function d(s,l){var r,c,u;if(void 0!==l.success&&"function"==typeof l.success||(l.success=function(e,t,a){}),void 0!==l.failed&&"function"==typeof l.failed||(l.failed=function(e,t){}),void 0===l.withLoader&&(l.withLoader=!0),void 0===l.headers&&(l.headers={}),void 0===l.data&&(l.data={}),l.data.nonce=window.PAGE.nonce,l.data.actionType=s,void 0!==l.data.file)return void 0!==l.progress&&"function"==typeof l.progress||(l.progress=function(e,t){}),void 0!==l.cancel&&"function"==typeof l.cancel||(l.cancel=function(){return!1}),r=2097152,(c=Math.ceil(l.data.file.size/r))<=(u=0)?void l.failed("Failed calculation file chunks"):void function n(e){if(!l.cancel()){var t,a=u*r,o=Math.min(a+r,l.data.file.size),a=l.data.file.slice(a,o),i=new FormData;for(t in l.data)"file"!==t&&i.append(t,l.data[t]);i.append("file",a),i.append("fileName",l.data.file.name),i.append("fileSize",l.data.file.size),void 0!==e&&i.append("fileUploadId",e),d(s,{data:i,withLoader:!1,headers:{"Content-Type":void 0},success:function(e,t,a){u++,l.progress(Math.min(Math.floor(u/c*100),100)),u<c?n(e.upload_id):l.success(e,t,a)},failed:function(e,t){l.progress(100),l.failed(e,t)}})}}();l.withLoader&&n.start(),t.post(window.PAGE.path.api,l.data,{headers:l.headers}).then(function(e){if(void 0===e.data.success&&e.data.includes("<html")&&window.location.reload(),window.PAGE.nonce!==e.data.system.nonce&&(window.PAGE.nonce=e.data.system.nonce),e.data.message){var t=[];if(t.push("exceptions|:|"+e.data.message),!e.data.success&&e.data.data.length)for(var a=0;a<e.data.data.length;a++)t.push(e.data.data[a]);e.data.message=o.t.apply(o,t)}l.withLoader&&n.complete(),e.data.success?l.success(e.data.data,e.data.message,e.data.system):l.failed(e.data.message,e.data.system)},function(){l.withLoader&&n.complete()})}return{getSettings:function(e,t){d("getSettings"+String(e).charAt(0).toUpperCase()+String(e).slice(1),t)},manageSettings:function(e,t){d("manageSettings"+String(e).charAt(0).toUpperCase()+String(e).slice(1),t)},addToQueue:function(e){d("addToQueue",e)},custom:d,editBackupNotes:function(e){d("editBackupNotes",e)},genDestinationAuth:function(e){d("genDestinationAuth",e)},getBackup:function(e){d("getBackup",e)},getBackupJob:function(e){d("getBackupJob",e)},getConfig:function(e){d("getConfig",e)},getDashboard:function(e){d("getDashboard",e)},getDestination:function(e){d("getDestination",e)},getQueueItem:function(e){d("getQueueItem",e)},getSchedule:function(e){d("getSchedule",e)},getSystemInfo:function(e){d("getSystemInfo",e)},getDatabaseTables:function(e){d("getDatabaseTables",e)},getQRCode:function(e){d("getQRCode",e)},exportBackup:function(e){d("exportBackup",e)},listAlerts:function(e){d("listAlerts",e)},listBackupJobs:function(e){d("listBackupJobs",e)},listBackups:function(e){d("listBackups",e)},listDestinations:function(e){d("listDestinations",e)},listDownloads:function(e){d("listDownloads",e)},listQueueItems:function(e){d("listQueueItems",e)},listSchedules:function(e){d("listSchedules",e)},listDatabaseTables:function(e){d("listDatabaseTables",e)},lockSnapshot:function(e){d("lockSnapshot",e)},manageBackupJob:function(e){d("manageBackupJob",e)},manageSchedule:function(e){d("manageSchedule",e)},manageDestination:function(e){d("manageDestination",e)},manageConfig:function(e){d("manageConfig",e)},deleteBackupJob:function(e){d("deleteBackupJob",e)},abortQueueItem:function(e){d("abortQueueItem",e)},deleteDestination:function(e){d("deleteDestination",e)},startOverQueueItem:function(e){d("startOverQueueItem",e)},deleteSchedule:function(e){d("deleteSchedule",e)},deleteDownload:function(e){d("deleteDownload",e)},duplicateBackupJob:function(e){d("duplicateBackupJob",e)},deleteSnapshot:function(e){d("deleteSnapshot",e)},enableBackupJob:function(e){d("enableBackupJob",e)},sendTestEmail:function(e){d("sendTestEmail",e)},createSupportUser:function(e){d("createSupportUser",e)},destinationSetExportConfig:function(e){d("destinationSetExportConfig",e)},enableDestination:function(e){d("enableDestination",e)},validateDestination:function(e){d("validateDestination",e)},validateMFA:function(e){d("validateMFA",e)},clearCompletedQueueItems:function(e){d("clearCompletedQueueItems",e)},clearAlerts:function(e){d("clearAlerts",e)},fileManager:function(e){d("fileManager",e)},getLog:function(e){d("getLog",e)}}}])}),define("services/util",["app"],function(e){e.factory("util",[function(){var o={getChanges:function(e,t,a,n){if(void 0===e||void 0===t)return{};if(!this.isObject(e)||!this.isObject(t))throw"Invalid argument. Function given, object expected.";var o,i={};for(o in t)void 0!==a&&0<=a.indexOf(o)||("_id"===o||void 0!==n&&"function"==typeof n&&n(o)||this.changedValue(e[o],t[o]))&&(i[o]=t[o]);return i},isChanged:function(e,t,a){if(void 0!==e&&void 0!==t){if(!this.isObject(e)||!this.isObject(t))throw"Invalid argument. Function given, object expected.";for(var n in t)if(!(void 0!==a&&0<=a.indexOf(n))&&this.changedValue(e[n],t[n]))return!0}return!1},changedValue:function(e,t){if(this.isFunction(e)||this.isFunction(t))throw"Invalid argument. Function given, object expected.";if(this.isValue(t))return!/^object:[0-9]+$/.test(t)&&e!==t;var a,n,o={};for(a in t)if(o[a]=1,!this.isFunction(t[a])){if(void 0===e||void 0===e[a])return!0;if(this.changedValue(e[a],t[a]))return!0}for(n in e)if(!o[n])return!0;return!1},isFunction:function(e){return"[object Function]"==={}.toString.apply(e)},isArray:function(e){return"[object Array]"==={}.toString.apply(e)},isObject:function(e){return"[object Object]"==={}.toString.apply(e)},isDate:function(e){return"[object Date]"==={}.toString.apply(e)},isValue:function(e){return!this.isObject(e)&&!this.isArray(e)}};return{sizeToHumanReadable:function(e,t,a){return(this.sizeToNumber(e,t,a)+" "+this.sizeToType(e,t)).trim()},sizeToNumber:function(e,t,a){void 0===a&&(a=2);var n,t=(t=void 0===t?!1:t)?1e3:1024;return e<t?e:(n=parseInt(Math.log(e)/Math.log(t)),(e/Math.pow(t,n)).toFixed(a))},sizeToType:function(e,t){var a=(t=void 0===t?!1:t)?1e3:1024;return e<a?"B":(t?"kMGTPE":"KMGTPE")[parseInt(Math.log(e)/Math.log(a))-1]+"B"},copyToClipboard:function(e){var t=document.createElement("textarea"),e=(t.style.position="fixed",t.style.opacity="0",t.textContent=e,document.getElementsByTagName("body")[0]);e.appendChild(t),t.select(),document.execCommand("copy"),e.removeChild(t)},countObj:function(e){var t,a=0;for(t in e)a++;return a},saveParams:function(e,t,a,n){return o.getChanges(t,e,a,n)},duplicateObject:function(e){return JSON.parse(JSON.stringify(e))},isChanged:function(e,t,a){return o.isChanged(t,e,a)},sleep:function(e){for(var t=Date.now();Date.now()-t<e;);},versionCompare:function(e,t,a){e=e.replace("-","."),t=t.replace("-",".");var n=a&&a.lexicographical,a=a&&a.zeroExtend,o=e.split("."),i=t.split(".");function s(e){return(n?/^\d+[A-Za-z]*$/:/^\d+$/).test(e)}if(!o.every(s)||!i.every(s))return NaN;if(a){for(;o.length<i.length;)o.push("0");for(;i.length<o.length;)i.push("0")}n||(o=o.map(Number),i=i.map(Number));for(var l=0;l<o.length;++l){if(i.length==l)return 1;if(o[l]!=i[l])return o[l]>i[l]?1:-1}return o.length!=i.length?-1:0}}}])}),define("services/consts",["app"],function(e){e.factory("consts",["lang",function(e){var t={NOTIFICATION_FREQUENCY_DISABLED:0,NOTIFICATION_FREQUENCY_REAL_TIME:1,NOTIFICATION_FREQUENCY_DAILY:2,ALERT_LEVEL_INFO:1,ALERT_LEVEL_WARNING:2,ALERT_LEVEL_CRITICAL:4,ENGINE_WORDPRESS:1,ENGINE_JETBACKUP_LINUX:2,ENGINE_JETBACKUP_SGB:3,DOCS_URL:"https://docs.jetbackup.com/v5.3",CHANGELOG_URL:"https://changelog.jetbackup.com",REQUEST_URL:"https://request.jetapps.com",FORUM_URL:"https://forum.jetapps.com",BLOG_URL:"https://blog.jetapps.com",ID_FIELD:"_id",MANAGE_BACKUP_JOB_NAME:"name",MANAGE_BACKUP_JOB_TYPE:"type",MANAGE_BACKUP_JOB_CONTAINS:"backup_contains",MANAGE_BACKUP_JOB_CONTAINS_FILES_TEXT:"contains_files",MANAGE_BACKUP_JOB_CONTAINS_DATABASE_TEXT:"contains_database",MANAGE_BACKUP_JOB_NEXT_RUN:"next_run",MANAGE_BACKUP_JOB_LAST_RUN:"last_run",MANAGE_BACKUP_JOB_ENABLED:"enabled",MANAGE_BACKUP_JOB_HIDDEN:"hidden",MANAGE_BACKUP_JOB_UNIQUE_ID:"unique_id",MANAGE_BACKUP_JOB_DESTINATIONS:"destinations",MANAGE_BACKUP_JOB_EXCLUDES:"excludes",MANAGE_BACKUP_JOB_SCHEDULES:"schedules",MANAGE_BACKUP_JOB_SCHEDULE_TIME:"schedule_time",MANAGE_BACKUP_JOB_JOB_MONITOR:"job_monitor",MANAGE_BACKUP_JOB_EXCLUDE_DATABASES:"database_excludes",MANAGE_BACKUP_JOB_CONTAINS_HOMEDIR:1,MANAGE_BACKUP_JOB_CONTAINS_DATABASE:2,MANAGE_SETTINGS_SECURITY_MFA_ENABLED:"MFA_ENABLED",MANAGE_BACKUP_JOB_TYPE_ACCOUNT:1,MANAGE_BACKUP_JOB_STRUCTURE_INCREMENTAL:2,BACKUP_ACCOUNT_CONTAINS_HOMEDIR:1,BACKUP_ACCOUNT_CONTAINS_DATABASE:2,BACKUP_STRUCTURE_ARCHIVED:1,BACKUP_STRUCTURE_COMPRESSED:2,BACKUP_STRUCTURE_INCREMENTAL:3,BACKUP_ACTION_RESTORE:"restore",BACKUP_ACTION_DOWNLOAD:"download",BACKUP_ACTION_EXTRACT:"extract",BACKUP_ACTION_EXPORT:"export",BACKUP_ACTION_LOCK:"lock",BACKUP_ACTION_DELETE:"delete",BACKUP_ACTION_EDIT_NOTES:"editNotes",QUEUE_TYPE_BACKUP:1,QUEUE_TYPE_RESTORE:2,QUEUE_TYPE_DOWNLOAD:4,QUEUE_TYPE_REINDEX:8,QUEUE_TYPE_RETENTION_CLEANUP:16,QUEUE_TYPE_SYSTEM:32,QUEUE_TYPE_EXPORT:64,QUEUE_TYPE_EXTRACT:128,QUEUE_TYPE_FIELD:"type",QUEUE_TYPE_DOWNLOAD_NAME:"download",QUEUE_TYPE_ABORT_NAME:"abort",QUEUE_TYPE_STARTOVER_NAME:"startover",QUEUE_TYPE_EXTRACT_NAME:"showExtractPath",QUEUE_TYPE_DOWNLOAD_LOGS_NAME:"downloadLogs",QUEUE_TYPE_VIEW_LOGS_NAME:"getLog",QUEUE_TYPE_COMPLETE_RESTORE:"completeRestore",QUEUE_STATUS_PENDING:1,QUEUE_STATUS_STARTED:2,QUEUE_STATUS_PREPARING:3,QUEUE_EXTERNAL_RESTORE_READY:40,QUEUE_STATUS_DONE:100,QUEUE_STATUS_PARTIALLY:101,QUEUE_STATUS_FAILED:102,QUEUE_STATUS_ABORTED:103,QUEUE_STATUS_NEVER_FINISHED:104,EXPORT_TYPE_CPANEL:1,EXPORT_TYPE_DA:2,PANEL_TYPE_FIELD:"panel_type",MANAGE_SCHEDULE_NAME:"name",MANAGE_SCHEDULE_TYPE:"type",MANAGE_SCHEDULE_INTERVALS:"intervals",MANAGE_SCHEDULE_BACKUP_ID:"backup_id",BACKUP_JOB_NOTES:"notes",SCHEDULE_TYPE_HOURLY:1,SCHEDULE_TYPE_DAILY:2,SCHEDULE_TYPE_WEEKLY:3,SCHEDULE_TYPE_MONTHLY:4,SCHEDULE_TYPE_MANUALLY:5,SCHEDULE_TYPE_AFTER_JOB_DONE:6,RESTORE_DATABASE_ENTIRE:1,RESTORE_FILES_ENTIRE:2,RESTORE_MULTISITE_ENTIRE_NETWORK:4,RESTORE_MULTISITE_SPECIFIC_SITE:8,RESTORE_MULTISITE_AS_DOMAIN:16,RESTORE_MULTISITE_STAND_ALONE:32,RESTORE_DATABASE_EXCLUDE:64,RESTORE_DATABASE_SKIP:128,RESTORE_DATABASE_INCLUDE:256,RESTORE_FILES_EXCLUDE:512,RESTORE_FILES_SKIP:1024,RESTORE_FILES_INCLUDE:2048,DESTINATIONS_DEFAULT_FOLDER:"/backup",DESTINATIONS_DEFAULT_PORT_FTP:21,DESTINATIONS_DEFAULT_PORT_SSH:22,DESTINATIONS_DEFAULT_TIMEOUT:60,DESTINATIONS_DEFAULT_RETRIES:5,DESTINATIONS_DISK_SPACE_LIMIT:{Disabled:0,"50%":50,"55%":55,"60%":60,"65%":65,"70%":70,"75%":75,"80%":80,"85%":85,"90%":90,"95%":95,"96%":96,"97%":97,"98%":98,"99%":99},CHUNK_SIZES_LIST:{"1MB":1,"2MB":2,"3MB":3,"4MB":4,"5MB":5,"6MB":6,"8MB":8,"10MB":10,"12MB":12,"14MB":14,"16MB":16,"20MB":20,"24MB":24,"32MB":32,"64MB":64},EXECUTION_TIME_LIST:{"Use server defaults":0,"10s":10,"20s":20,"30s":30,"40s":40,"50s":50,"60s":60,"120s":120,"300s":300,"600s":600}};return t.ALERT_LEVEL_NAMES={[t.ALERT_LEVEL_INFO]:"Information",[t.ALERT_LEVEL_WARNING]:"Warning",[t.ALERT_LEVEL_CRITICAL]:"Critical"},t.ALERT_FREQUENCIES={[t.NOTIFICATION_FREQUENCY_DISABLED]:e.t("Disabled"),[t.NOTIFICATION_FREQUENCY_REAL_TIME]:e.t("Real Time"),[t.NOTIFICATION_FREQUENCY_DAILY]:e.t("Once A Day")},t.BACKUP_ACCOUNT_CONTAINS_FULL=t.BACKUP_ACCOUNT_CONTAINS_HOMEDIR|t.BACKUP_ACCOUNT_CONTAINS_DATABASE,t}])}),define("services/meta",["app"],function(e){e.factory("meta",["storage","lang",function(a,i){function t(e){if(void 0===e)throw Error("No storage name provided");for(var t in this._storage_id=e,this._storage=a.create("sort_"+this._storage_id),this._noneStorage[this._storage_id]={},this._defaults)(0<=this._noneStorageKeys.indexOf(t)||!this._storage.isSet(t))&&this.set(t,this._defaults[t])}return t.prototype={_defaults:{sortReverse:!1,sortBy:"",sortDirection:"",sortFields:[],filterValue:"",maxPages:3,totalItems:0,currentPage:1,pageSize:10,pageSizes:[10,15,20,25,50,75,100],start:0,limit:25,itemCountText:void 0},_noneStorageKeys:["filterValue"],_noneStorage:{},_storage_id:void 0,_storage:void 0,_storage_key:void 0,_show_count_text:!1,_onChangeFunction:function(){},onChange:function(e){this._onChangeFunction=e},set:function(e,t){0<=this._noneStorageKeys.indexOf(e)?this._noneStorage[this._storage_id][e]=t:(this._storage.set(e,t),this._storage.save()),this._onChangeFunction()},get:function(e,t){return this._storage.get(e,t)},setSortReverse:function(e){this.set("sortReverse",e)},getSortReverse:function(){return this.get("sortReverse")},setSortBy:function(e){this.set("sortBy",e)},getSortBy:function(){return this.get("sortBy")},setSortDirection:function(e){this.set("sortDirection",e)},getSortDirection:function(){return this.get("sortDirection")},getSortDirectionInt:function(){return"asc"===this.getSortDirection()?1:-1},setSortFields:function(e){this.set("sortFields",e)},getSortFields:function(){return this.get("sortFields")},setFilter:function(e){this._noneStorage[this._storage_id].filterValue=e},getFilter:function(){return this._noneStorage[this._storage_id].filterValue},setMaxPages:function(e){this.set("maxPages",e)},getMaxPages:function(){return this.get("maxPages")},setTotalItems:function(e){this.set("totalItems",parseInt(e))},getTotalItems:function(){return this.get("totalItems")},setCurrentPage:function(e){this.set("currentPage",e)},getCurrentPage:function(){return this.get("currentPage")},setPageSize:function(e){this.set("pageSize",e)},getPageSize:function(){return this.get("pageSize")},setPageSizes:function(e){this.set("pageSizes",e)},getPageSizes:function(){return this.get("pageSizes")},setStart:function(e){this.set("start",e)},getStart:function(){return this.get("start")},setLimit:function(e){this.set("limit",e)},getLimit:function(){return this.get("limit")},setItemCountText:function(e){this.set("itemCountText",e)},getItemCountText:function(){return this.get("itemCountText")},showItemCountText:function(){return this._show_count_text=!0,this._show_count_text},getSkip:function(){return(this.getCurrentPage()-1)*this.getPageSize()},showPagination:function(){return this.get("showPagination",!1)},setData:function(e){for(var t in e)this._noneStorageKeys.indexOf(t)<0||(this._noneStorage[this._storage_id][t]=e[t]);this._storage.setData(e)},getData:function(){var e,t=this._noneStorage[this._storage_id],a=this._storage.getData();for(e in a)0<=this._noneStorageKeys.indexOf(e)||(t[e]=a[e]);return t},reset:function(){this.setCurrentPage(1)},calculate:function(e){void 0===e&&(e=[]);var t,a=this.getTotalItems(),n=this.getPageSize(),o=this.getCurrentPage();n<a||1<o?(this.set("showPagination",!0),this.setStart(1+(t=(o-1)*n)),this.setLimit(Math.min(a,t+e.length))):(this.set("showPagination",!0),this.setStart(0===e.length?0:1),this.setLimit(e.length)),this.setItemCountText(i.t("Displaying %s to %s out of %s records",this.getStart(),Math.min(n*o,a),a))},_min:function(e){for(var t=null,a=0;a<e.length;a++)(null===t||e[a]<t)&&(t=e[a]);return null===t?0:t}},{new:function(e){return new t(e)}}}])}),define("services/storage",["app"],function(e){e.factory("storage",[function(){function t(e){if(void 0===e)throw Error("You must provide pool name");this._storage_name="JetBackupWPStorage_"+e,this._data={},void 0===(e=localStorage.getItem(this._storage_name))?this.save():this.setData(JSON.parse(e))}return t.prototype={_storage_name:void 0,_data:null,set:function(e,t){this._data[e]=t},get:function(e,t){return void 0!==this._data[e]?this._data[e]:t},isSet:function(e){return void 0!==this._data[e]},remove:function(e){delete this._data[e]},save:function(){localStorage.setItem(this._storage_name,JSON.stringify(this._data))},setData:function(e){e&&(this._data=e)},getData:function(){return this._data},destroy:function(){localStorage.removeItem(this._storage_name),this._data={}}},{create:function(e){return new t(e)},delete:function(e){if(void 0===e)throw Error("You must provide pool name");localStorage.removeItem("JetBackupWPStorage_"+e)},deleteAll:function(){localStorage.clear()},exists:function(e){return!!localStorage.getItem("JetBackupWPStorage_"+e)}}}])}),define("services/alert",["app"],function(e){e.factory("alert",["$rootScope",function(n){function a(e,t,a){void 0===a&&(a=1e4),void 0===n.alerts&&(n.alerts=[]),n.alerts.unshift({message:e,type:t,closeable:!0,ttl:a})}return a.prototype={},{success:function(e,t){a(e,"success",t)},error:function(e,t){a(e,"danger",t)},warning:function(e,t){a(e,"warning",t)},info:function(e,t){a(e,"info",t)}}}])}),define("services/lang",["app"],function(e){e.factory("lang",["$i18next","$location",function(o,a){return{_ns:"",setNS:function(e,t){var a=this;a._ns=e,void 0!==t&&t.$on("$destroy",function(){a.resetNS()})},resetNS:function(){this._ns=""},loadNS:function(e){o.loadNamespaces(e)},setDefaultNS:function(e){this.loadNS(e),o.setDefaultNamespace(e)},initNS:function(e){var t=a.path();(t=(t=t.split("/")[1])||void 0===e?t:e)?this.setDefaultNS(t):$rootScope.$broadcast("i18nextNSLoad",this._ns)},t:function(){var e,t=[];for(e in arguments)t.push(arguments[e]);var a=t.slice(1),n=(this._ns?this._ns+"|:|":"")+t[0];return a.length?o.t(n,{postProcess:"sprintf",sprintf:a}):o.t(n)},d:function(e){e=moment(1e3*e);return window.PAGE.info.utcOffset&&e.utcOffset(window.PAGE.info.utcOffset),e.format(window.PAGE.dateFormat+" "+window.PAGE.timeFormat)}}}])}),define("services/popup",["app"],function(e){e.factory("popup",["$rootScope","$uibModal","lang","popupPosition",function(t,a,e,n){function o(e){this._init(e)}return o.prototype={_options:{},_init:function(e){this._options=e},open:function(){void 0===this._options.size&&(this._options.size="md"),void 0===this._options.resolve&&(this._options.resolve={}),void 0===this._options.template&&(this._options.template=""),void 0===this._options.templateViews&&(this._options.templateViews=""),void 0===this._options.noController&&(this._options.noController=!1),void 0===this._options.controller&&(this._options.controller=""),void 0===this._options.scope&&(this._options.scope=t);var e=a.open({animation:!0,size:this._options.size,ariaLabelledBy:"modal-title",ariaDescribedBy:"modal-body",templateUrl:t.includePath(this._options.template,this._options.templateViews),controller:this._options.noController?null:this._options.controller||this._options.template,scope:this._options.scope,resolve:this._options.resolve});return e.opened.then(function(){n.update()}),e}},{open:function(e){return new o(e).open()}}}])}),define("services/popupPosition",["app"],function(e){e.factory("popupPosition",[function(){function e(){this._init()}return e.prototype={_window:window,_offset:0,_position:0,_iframe:!1,_listener_state:void 0,_listener_funcs:{window:void 0},_init:function(){this._calculate()},_calculate:function(){this._calculateWindow(),this._listener()},_calculateWindow:function(){var e=this;for(e._window=window,e._offset=0,e._iframe=!1;;){var t=e._window.location.href,a=e._window.parent;try{if(void 0===a||a===e._window||!1===a.document)break}catch(e){break}e._iframe=!0;var n=a.document.getElementsByTagName("iframe");e._window=a;for(var o=0;o<n.length;o++){var i=n[o];if(i.src.substr(0,i.src.indexOf("?"))===t.substr(0,t.indexOf("?"))){var s,i=i.getBoundingClientRect().top,l=e._window.scrollY;void 0!==e._window.popupPosition&&void 0!==(s=e._window.popupPosition).id&&void 0!==(s=e._window.document.getElementById(s.id))&&(i-=s.getBoundingClientRect().top,l=s.scrollTop),e._offset+=l+i;break}}}e._window.onresize=function(){e._calculate()}},_listener:function(){var t,e,a,n,o,i;this.insideIframe()&&(e=void 0!==(t=this)._window.popupPosition&&void 0!==t._window.popupPosition.id?t._window.popupPosition.id:"window",t._listener_state&&t._listener_state===e&&void 0!==t._listener_funcs[e]||((n=a=void 0)!==t._window.popupPosition?void 0!==(o=t._window.popupPosition).id&&void 0!==(i=t._window.document.getElementById(o.id))&&(a=function(){var e=void 0!==o.offset?o.offset:0;t._scroll(i.scrollTop+e)},n=i):(a=function(){t._scroll(t._window.scrollY)},n=t._window),t._listener_state=e,t._listener_funcs[e]=a,void 0!==n&&n.addEventListener("scroll",a)))},_scroll:function(e){this._position=e-this._offset,this._position<0&&(this._position=0),this.update()},update:function(){if(this._calculate(),this.insideIframe()){var e=document.getElementById("alert-floating-container"),t=(e&&(e.style.top=this._position+"px"),document.getElementsByClassName("modal"));if(t)for(var a=0;a<t.length;a++)t[a].style.top=this._position+"px"}},insideIframe:function(){return!!this._iframe}},new e}])}),define("services/pathManager",["app"],function(e){e.factory("pathManager",[function(){function t(e){this._init(e)}return t.prototype={_tree:{},_init:function(e){if(this._tree={},void 0!==e)for(var t=0;t<e.length;t++)this.addPath(e[t])},_getCurrent:function(e){for(var t=e.split("/"),a=this.getTree();t.length;){var n=t.shift();if(n){if(void 0===a[n])return!1;a=a[n]}}return a},_countObj:function(e){var t,a=0;for(t in e)a++;return a},isExists:function(e){return!!this._countObj(this.getTree())&&!!(e=this._getCurrent(e))&&!this._countObj(e)},isParent:function(e){return!!this._countObj(this.getTree())&&!!(e=this._getCurrent(e))&&!!this._countObj(e)},isChildren:function(e){if(this._countObj(this.getTree()))for(var t=e.split("/"),a=this.getTree();t.length;){var n=t.shift();if(n){if(void 0===a[n])return!this._countObj(a);a=a[n]}}return!1},addPath:function(e){for(var t,a=e.split("/"),n=this.getTree();a.length;){var o=a.shift();o&&(void 0===n[o]&&(n[o]={}),n=n[o])}for(t in n)delete n[t]},removePath:function(e){for(var t=e.split("/"),a=this.getTree(),n=[];t.length;){var o=t.shift();if(o){if(void 0===a[o])return!1;n.push({instance:a,name:o}),a=a[o]}}if(n.length){var i=n.pop();for(delete i.instance[i.name];n.length;){if(i=n.pop(),0<this._countObj(i.instance[i.name]))return;delete i.instance[i.name]}}},getSelected:function(){for(var e=[],t=[{path:"",obj:this.getTree()}];t.length;){var a,n=t.shift();for(a in n.obj){var o=n.path+"/"+a;this._countObj(n.obj[a])?t.push({path:o,obj:n.obj[a]}):e.push(o)}}return e},getTree:function(){return this._tree}},{new:function(e){return new t(e)}}}])}),define("directives/loadingBox",["app"],function(e){e.directive("loadingBox",function(){return{restrict:"E",transclude:!0,template:'<div class="alert alert-info"><em class="fas fa-cog fa-spin"></em> <span ng-transclude></span></div>'}})}),define("directives/fileModel",["app"],function(e){e.directive("fileModel",["alert",function(i){return{scope:{fileModel:"="},link:function(n,o){o.bind("change",function(e){let t=e.target.files[0];var a;t&&(a=(e=t.name.toLowerCase()).endsWith(".tar"),e=e.endsWith(".tar.gz"),a||e?n.$apply(()=>{n.fileModel={name:t.name,size:t.size,type:t.type,object:t}}):(n.$apply(()=>{i.error("Only .tar and .tar.gz files are allowed."),n.fileModel={name:"",size:0,type:""}}),o.val(null)))})}}}])}),define("directives/alertBox",["app"],function(e){e.directive("alertBox",["$timeout","$compile","lang",function(l,e,t){function r(e,t,a){var n={};if(e)if(angular.isString(a))n.message=a;else{if(!angular.isObject(a))throw new TypeError("ngModel must be a string or object.");angular.copy(a,n)}if(angular.isDefined(n.type)||(angular.isDefined(t.type)&&t.type?n.type=t.type:n.type="warning"),angular.isDefined(n.closable)?n.closable="danger"!==n.type&&n.closable:angular.isDefined(t.closable)?n.closable="danger"!==n.type:n.closable=!1,angular.isDefined(n.autoClose)||angular.isDefined(t.autoClose)?n.autoClose="danger"!==n.type&&n.autoClose:n.autoClose=!1,angular.isDefined(n.id)||(angular.isDefined(t.id)?n.id=t.id:n.id="alert"+o++),!e||angular.isDefined(n.message)||n.message)return n;throw new Error("No message provided in the model's message property.")}var o=0,c=[{name:"errorLabel",defaultText:t.t("Error:")},{name:"warnLabel",defaultText:t.t("Warning:")},{name:"infoLabel",defaultText:t.t("Information:")},{name:"successLabel",defaultText:t.t("Success:")},{name:"moreLabel",defaultText:t.t("What went wrong?")}];return{restrict:"EA",template:"<div>\n    <div ng-show=\"alert.type === 'danger'\" class='alert alert-danger ng-hide'>\n        <button id=\"{{'btnClose_danger_' + alert.id}}\" type='button' class='close' ng-if='alert.closeable' ng-click='runClose()'>&times;</button>\n        <button id=\"{{'btnMore_danger_' + alert.id}}\" type='button' class='btn btn-more btn-link pull-right flip' ng-if='hasToggleHandler' ng-click='runToggleMore()'>{{moreLabel}}</button>\n        <div class='alert-message'>\n        <span class='fas fa-times-circle'></span>\n            <strong class=\"alert-title\" ng-show=\"errorLabel\">{{errorLabel}}</strong>\n            <span class=\"alert-body\"><span id=\"{{'txtMessage_danger_' + alert.id}}\" ng-bind-html=\"alert.message\" ng-if=\"alert && alert.message\"></span></span>\n            <ul ng-if=\"alert.list && alert.list.length\" class=\"alert-list\">\n                <li ng-repeat=\"value in alert.list\">\n                    <span id=\"{{'txtList_danger_' + alert.id + '_' + $index}}\" ng-bind-html=\"value\"></span>\n                </li>\n            </ul>\n        </div>\n    </div>\n\n    <div ng-show=\"alert.type === 'info'\" class='alert alert-info ng-hide'>\n        <button id=\"{{'btnClose_info_' + alert.id}}\" type='button' class='close' ng-if='alert.closeable' ng-click='runClose()'>&times;</button>\n        <button id=\"{{'btnMore_info_' + alert.id}}\" type='button' class='btn btn-more btn-link pull-right flip' ng-if='hasToggleHandler' ng-click='runToggleMore()'>{{moreLabel}}</button>\n        <div class='alert-message'>\n        <span class='fas fa-info-circle'></span>\n            <strong class=\"alert-title\" ng-show=\"infoLabel\">{{infoLabel}}</strong>\n            <span class=\"alert-body\"><span id=\"{{'txtMessage_info_' + alert.id}}\" ng-bind-html=\"alert.message\" ng-if=\"alert && alert.message\"></span></span>\n            <ul ng-if=\"alert.list && alert.list.length\" class=\"alert-list\">\n                <li ng-repeat=\"value in alert.list\">\n                    <span id=\"{{'txtList_info_' + alert.id + '_' + $index}}\" ng-bind-html=\"value\"></span>\n                </li>\n            </ul>\n        </div>\n    </div>\n\n    <div ng-show=\"alert.type === 'success'\" class='alert alert-success ng-hide'>\n        <button id=\"{{'btnClose_success_' + alert.id}}\" type='button' class='close' ng-if='alert.closeable' ng-click='runClose()'>&times;</button>\n        <button id=\"{{'btnMore_success_' + alert.id}}\" type='button' class='btn btn-more btn-link pull-right flip' ng-if='hasToggleHandler' ng-click='runToggleMore()'>{{moreLabel}}</button>\n        <div class='alert-message'>\n        <span class='fas fa-check-circle'></span>\n            <strong class=\"alert-title\" ng-show=\"successLabel\">{{successLabel}}</strong>\n            <span class=\"alert-body\"><span id=\"{{'txtMessage_success_' + alert.id}}\" ng-bind-html=\"alert.message\" ng-if=\"alert && alert.message\"></span></span>\n            <ul ng-if=\"alert.list && alert.list.length\" class=\"alert-list\">\n                <li ng-repeat=\"value in alert.list\">\n                    <span id=\"{{'txtList_success_' + alert.id + '_' + $index}}\" ng-bind-html=\"value\"></span>\n                </li>\n            </ul>\n        </div>\n    </div>\n\n    <div ng-show=\"alert.type === 'warning'\" class='alert alert-warning ng-hide'>\n        <button id=\"{{'btnClose_warning_' + alert.id}}\" type='button' class='close' ng-if='alert.closeable' ng-click='runClose()'>&times;</button>\n        <button id=\"{{'btnMore_warning_' + alert.id}}\" type='button' class='btn btn-more btn-link pull-right flip' ng-if='hasToggleHandler' ng-click='runToggleMore()'>{{moreLabel}}</button>\n        <div class='alert-message'>\n        <span class='fas fa-exclamation-circle'></span>\n"+'            <strong class="alert-title" ng-show="warnLabel">{{warnLabel}}</strong>\n            <span class="alert-body"><span id="{{\'txtMessage_warning_\' + alert.id}}" ng-bind-html="alert.message" ng-if="alert && alert.message"></span></span>\n            <ul ng-if="alert.list && alert.list.length" class="alert-list">\n                <li ng-repeat="value in alert.list">\n                    <span id="{{\'txtList_warning_\' + alert.id + \'_\' + $index}}" ng-bind-html="value"></span>\n                </li>\n            </ul>\n        </div>\n    </div>\n</div>',transclude:!0,replace:!0,require:"?ngModel",scope:{close:"&onClose",toggleMore:"&onToggleMore",autoClose:"=",errorLabel:"@",warnLabel:"@",infoLabel:"@",successLabel:"@",moreLabel:"@"},compile:function(e,t){return c.forEach(function(e){angular.isDefined(t[e.name])||(t[e.name]=e.defaultText)}),function(t,e,a,n,o){n?(n.$formatters.push(function(e){return r(!0,a,e)}),n.$render=function(){t.alert=n.$viewValue}):(t.alert=r(!1,a),o=o,i=(i=t).alert.type,s=e[0].querySelector(".alert-"+i).querySelector(".alert-body"),o(function(e){angular.element(s).append(e)})),t.$watch("alert.label",function(t){angular.isDefined(t)&&c.forEach(function(e){a.$set(e.name,t)})}),t.runClose=function(){var e;t.timer&&(e=t.timer,t.timer=null,delete t.timer,l.cancel(e)),t.$emit("closeAlertCalled",{id:t.alert.id}),t.alert.type=""};var i,s,e=t.autoClose?parseInt(t.autoClose,10):null;e&&!isNaN(e)&&(t.timer=l(function(){t.runClose()},e)),t.hasToggleHandler=angular.isDefined(a.onToggleMore),t.showMore=!1,t.runToggleMore=function(){t.showMore=!t.showMore;var e={id:t.alert.id,show:t.showMore};t.$emit("toggleMoreAlertCalled",e),t.toggleMore(e)}}}}}])}),define("directives/inputDropdown",["app"],function(e){e.directive("inputDropdown",["$parse","lang",function(e,i){return{restrict:"E",template:'<div class="input-group">        <span ng-show="prefix" class="input-group-addon">{{prefixLang}}</span>        <select class="form-control"            ng-options="value.key as value.label for value in values"            ng-model="input">        </select>        <span ng-show="input == \'CUSTOM\'" class="input-group-addon">-</span>\t\t <span ng-show="input == \'CUSTOM\'" ng-transclude></span></div>',require:"ngModel",transclude:!0,replace:!0,scope:{addon:"@",prefix:"@",options:"=",ngModel:"="},link:function(a,e,t,n,o){n&&(a.addonLang=a.addon||"",a.prefixLang=a.prefix||"",a.values=[],Object.keys(a.options).sort(function(e,t){return e-t}).forEach(function(e){var t=e;t==parseInt(t)&&(t=parseInt(t)),a.values.push({key:t,label:a.options[e]})}),a.values.push({key:"CUSTOM",label:i.t("Custom")}),n.$render=function(){for(var e in a.input=n.$viewValue,a.options)if((e=e==parseInt(e)?parseInt(e):e)===a.input)return;a.input="CUSTOM"},a.$watch("input",function(e,t){e!==t&&"CUSTOM"!==e&&n.$setViewValue(a.input)}))}}}])}),define("directives/pageSize",["app"],function(e){e.directive("pageSize",["$parse","pageSizeConfig","lang",function(i,s,l){var r=-1;return{restrict:"EA",template:'<div class="page-size">\n    <div ng-hide="autoHide && options[0].value >= totalItems" class="form-group" >\n        <label style="display: none;" for="{{parentID}}_select" class="title">{{pageSizeTitle}}</label>\n        <select aria-label="Page Size" id="{{parentID}}_select"\n            class="form-control"\n            ng-options="size.value as size.label for size in options"\n            ng-model="pageSize">\n        </select>\n    </div>\n</div>',require:"ngModel",replace:!0,scope:{parentID:"@id",totalItems:"=",allowedSizes:"=",showAll:"=",autoHide:"="},link:function(a,e,t,n){function o(){var e={},t=(e.allowedSizes=a.allowedSizes||s.allowedSizes,e.totalItems=a.totalItems||s.totalItems,e.showAllItems=a.showAll,a.showAll&&(r=a.totalItems||-1),e.allowedSizes.slice(0));return t.sort(function(e,t){return e-t}),t=t.map(function(e){return{label:e,value:e}}),e.showAllItems&&t.push({label:l.t("All"),value:r}),(1===t.length&&t[0].value===e.totalItems||0===t.filter(function(e){return e.value===a.pageSize}).length)&&(a.pageSize=t[0].value),t}n&&(t.allowedSizes&&a.$parent.$watch(i(t.allowedSizes),function(){a.options=o()}),t.totalItems&&a.$parent.$watch(i(t.totalItems),function(){a.options=o()}),t.showAll&&a.$parent.$watch(i(t.showAll),function(){a.options=o()}),n.$render=function(){a.pageSizeTitle=l.t("Page Size"),a.pageSize=n.$viewValue},a.$watch("pageSize",function(e,t){e!==t&&e&&n.$setViewValue(a.pageSize)}),a.$watch("totalItems",function(){a.options=o()}),a.options=o())}}}]),e.constant("pageSizeConfig",{allowedSizes:[10,20,50,100],totalItems:0,showAllItems:!1})}),define("directives/search",["app"],function(e){e.directive("search",["lang",function(n){return{restrict:"E",template:'<div class="input-group" style="max-width: 334px;">\n    <span  class="input-group-btn rounded-start-3 jb-top-form pt-15"><span class="icon"><i class="fa-sharp fa-light fa-search"></i></span></span>\n    <input type="search"\n        id="{{parentID}}_input"\n        class="form-control me-2 rounded-end-3 jb-top-form jb-grey-0 job_search"\n        placeholder="{{placeholder}}"\n        title="{{title}}"\n        ng-model="filterText"\n        ng-keyup="clear($event)"\n        ng-debounce\n        prevent-default-on-enter\n        auto-focus="{{autofocus}}"\n        aria-label="'+n.t("Search")+'"/>\n</div>',require:"ngModel",replace:!0,scope:{parentID:"@id",placeholder:"@?placeholder",autofocus:"@?autofocus",title:"@?title"},compile:function(){return{pre:function(e,t,a){angular.isUndefined(a.placeholder)&&(a.placeholder=n.t("Search")),angular.isUndefined(a.title)&&(a.title=n.t("Search")),angular.isUndefined(a.autofocus)?a.autofocus=!1:a.autofocus=!0,e.autofocus=a.autofocus,e.placeholder=a.placeholder,e.title=a.title,e.ariaLabelSearch=n.t("Search"),e.ariaLabelClear=n.t("Clear")},post:function(t,e,a,n){var o,i=n;i&&(i.$render=function(){t.filterText=i.$viewValue},t.clear=function(e){27===e.keyCode&&(t.filterText="")},o=null,t.$watch("filterText",function(){null!==o&&clearTimeout(o),o=setTimeout(function(){i.$setViewValue(t.filterText)},300)}))}}}}}])}),define("directives/sortBy",["app"],function(e){e.directive("sortBy",[function(){var n="asc";return{template:'<button class="sort-link" ng-click="sort(sortValue)">\n    <span ng-transclude></span>\n    <span ng-hide="sortMeta.getSortBy() !== sortField">\n        <i class="fas" ng-class="{true: \'fa-sort-up\', false: \'fa-sort-down\'}[sortMeta.getSortDirection() == \'asc\']"\n           ng-attr-title="{{ getTitle() }}"></i>\n    </span>\n</button>',restrict:"EA",transclude:!0,replace:!0,scope:{sortMeta:"=",sortType:"@",sortField:"@",sortReverse:"@",sortAscendingTitle:"@",sortDescendingTitle:"@",sortReverseDefault:"@",onsort:"&"},compile:function(e,t){return t.sortAscendingTitle||(t.sortAscendingTitle="Ascending"),t.sortDescendingTitle||(t.sortDescendingTitle="Descending"),function(a,e,t){a.getTitle=function(){return a.sortMeta.getSortDirection()===n?t.sortAscendingTitle:t.sortDescendingTitle},a.sort=function(){var e=a.sortMeta,t=(e.getSortBy()===a.sortField?e.setSortDirection(e.getSortDirection()===n?"desc":n):(e.setSortBy(a.sortField),e.setSortDirection(n)),a.onsort());angular.isFunction(t)&&t(e)}}}}}])}),define("directives/pagination",["app"],function(e){e.directive("pagination",[function(){return{template:'<div class="d-flex justify-content-center mt-30 ">\n    <div class="jb_pagination">\n        <div class="d-flex pagination-pages">\n                <ul uib-pagination\n                        total-items="meta.getTotalItems()"\n                        ng-model="currentPage"\n                        max-size="meta.getMaxPages()"\n                        boundary-links="false"\n                        direction-links="true"\n                        rotate="false"\n                        previous-text="<"\n                        next-text=">"\n                        items-per-page="meta.getPageSize()"\n                        ng-show="meta.showPagination()">\n                </ul>\n                <page-size id="table_items_per_page"\n                        allowed-sizes="meta.getPageSizes()"\n                        total-items="meta.getTotalItems()"\n                        ng-model="pageSize"\n                        show-all="false"\n                        ng-show="!hidePageSize && meta.showPagination()">\n                </page-size--\x3e\n        </div>\n    </div>\n</div>\n<div class="d-flex justify-content-center mt-2">\n    <div class="text-center">\n        <span ng-show="meta.showItemCountText()" id="record-info">{{ meta.getItemCountText() }}</span>\n    </div>\n</div>',scope:{meta:"=",fetch:"=",hidePageSize:"="},link:function(a){a.currentPage=a.meta.getCurrentPage(),a.pageSize=a.meta.getPageSize(),a.meta.onChange(function(){a.currentPage=a.meta.getCurrentPage(),a.pageSize=a.meta.getPageSize()}),a.$watch("currentPage",function(e,t){e!==t&&(a.meta.setCurrentPage(a.currentPage),a.meta.getTotalItems()>a.meta.getSkip())&&a.fetch()}),a.$watch("pageSize",function(e,t){e!==t&&(a.meta.setPageSize(a.pageSize),a.meta.getTotalItems()>a.meta.getSkip())&&a.fetch()})}}}])}),define("directives/navigation",["app"],function(e){e.directive("navigation",["$rootScope","$location","lang",function(t,a,n){return{template:'<nav class="jb-navbar jb-white-0 navbar navbar-expand-lg bg-light"><div class="container-fluid jb-navbar-container "><div class="collapse navbar-collapse justify-content-center jb-top-menu" id="xnavbarNavAltMarkup"><div class="navbar-nav d-flex"><a ng-repeat="option in options" class="nav-link" ng-class="{ \'current\': active == option.class }" href="{{url}}{{option.href}}" ng-click="changePath(option.href)"> <em aria-hidden="true" class="jb-navicon {{ option.icon }}"></em>{{ option.label }}</a></div></div></div></nav>',scope:{collapsed:"=",active:"="},link:function(e){e.changePath=function(e){a.path(e)},e.url=t.primaryURL,e.options=[{label:n.t("Dashboard"),href:"/",class:"Dashboard",icon:"fas fa-home"},{label:n.t("Backups"),href:"/backups",class:"Backups",icon:"fas fa-file-lines"},{label:n.t("Backup Jobs"),href:"/jobs",class:"Jobs",icon:"fas fa-file-shield"},{label:n.t("Destinations"),href:"/destinations",class:"Destinations",icon:"fas fa-server"},{label:n.t("Schedules"),href:"/schedules",class:"Schedules",icon:"fas fa-calendar-days"},{label:n.t("Queue"),href:"/queue",class:"Queue",icon:"fas fa-clock"},{label:n.t("Downloads"),href:"/downloads",class:"Downloads",icon:"fas fa-folder"},{label:n.t("Alerts"),href:"/alerts",class:"Alerts",icon:"fas fa-exclamation-circle"},{label:n.t("System Info"),href:"/system",class:"System",icon:"fas fa-circle-info"},{label:n.t("Settings"),href:"/settings/general",class:"Settings",icon:"fas fa-cog"}]}}}])}),define("directives/stringToNumber",["app"],function(e){e.directive("stringToNumber",[function(){return{require:"ngModel",link:function(e,t,a,n){n.$parsers.push(function(e){return""+e}),n.$formatters.push(function(e){return parseFloat(e)})}}}])}),define("directives/validateField",["app"],function(e){e.directive("validateField",["$parse","lang",function(e,t){return{restrict:"A",require:"ngModel",replace:!1,scope:{min:"@",max:"@",regex:"@",ngModel:"="},link:function(t,a,n,o){o&&(t.$watch(function(){return o.$modelValue},function(e){t.oldValue=e}),a.on("blur",function(){if(t.newValue=o.$viewValue,""!==t.newValue){switch(n.validateField){case"int":t.newValue=parseInt(t.newValue),void 0!==t.min&&t.newValue<parseInt(t.min)&&(t.newValue=parseInt(t.min)),void 0!==t.max&&t.newValue>parseInt(t.max)&&(t.newValue=parseInt(t.max));break;case"float":t.newValue=parseFloat(t.newValue),void 0!==t.min&&t.newValue<parseFloat(t.min)&&(t.newValue=parseFloat(t.min)),void 0!==t.max&&t.newValue>parseFloat(t.max)&&(t.newValue=parseFloat(t.max));break;case"str":new RegExp(t.regex).test(t.newValue)||(t.newValue=""),void 0!==t.max&&t.newValue.length>parseInt(t.max)&&(t.newValue=t.newValue.substr(0,parseInt(t.max)));break;case"path":new RegExp(/^(\/[\w\s\d.-]+)+\/?$/).test(t.newValue)||(t.newValue="");break;case"color":new RegExp(/^#[a-fA-F0-9]{3}(?:[a-fA-F0-9]{3})?$/).test(t.newValue)||(t.newValue="");break;case"binary":new RegExp(/^((\/[\w\s\d]+)+\/?|[\w]+)$/).test(t.newValue)||(t.newValue="");break;case"email":new RegExp(/^(([^<>()\[\]\\.,;:\s@"]+(\.[^<>()\[\]\\.,;:\s@"]+)*)|(".+"))@((\[[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}\])|(([a-zA-Z\-0-9]+\.)+[a-zA-Z]{2,}))$/).test(t.newValue)||(t.newValue="")}var e;t.oldValue!=t.newValue&&((e=a).css({borderColor:"#cc0000"}),setTimeout(function(){e.css({borderColor:"inherit"})},2e3),o.$setViewValue(t.newValue),o.$render())}}))}}}])}),require(["app","controllers/queueHandler","controllers/dashboard","controllers/destinations","controllers/schedules","controllers/system","controllers/jobs","controllers/alerts","controllers/backups","controllers/queue","controllers/downloads","controllers/settings","controllers/mfa","controllers/fileManager","controllers/404","controllers/modal/manageDestination","controllers/modal/manageBackupJob","controllers/modal/manageSchedule","controllers/modal/importBackup","controllers/modal/restoreBackup","controllers/modal/exportBackup","controllers/modal/editBackupNotes","controllers/modal/lockBackup","controllers/modal/deleteBackup","controllers/modal/showExtractedPath","controllers/modal/callSupport","controllers/modal/viewLog","controllers/destinations/FTP","controllers/destinations/SFTP","controllers/destinations/S3","controllers/destinations/JetStorage","controllers/destinations/GoogleDrive","controllers/destinations/OneDrive","controllers/destinations/DropBox","controllers/destinations/Box","controllers/destinations/pCloud","services/api","services/util","services/consts","services/meta","services/storage","services/alert","services/lang","services/popup","services/popupPosition","services/pathManager","directives/loadingBox","directives/fileModel","directives/alertBox","directives/inputDropdown","directives/pageSize","directives/search","directives/sortBy","directives/pagination","directives/navigation","directives/stringToNumber","directives/validateField"],function(e){angular.bootstrap(document,["JetBackupApp"])}),define("main",function(){});