<?php

namespace JetBackup\Ajax\Calls;

use JetBackup\Ajax\aAjax;
use JetBackup\Cron\Cron;
use JetBackup\Exception\AjaxException;
use JetBackup\Factory;
use JetBackup\Wordpress\Helper;

if (!defined( '__JETBACKUP__')) die('Direct access is not allowed');

/**
 * Helper function to run the cron from cli (WP Only)
 */
class ExecuteCron extends aAjax {

	/**
	 * @inheritDoc
	 */
	public function execute(): void {
		if(!$this->isCLI() || !Helper::isWPCli()) throw new AjaxException("Can only execute through wp cli");
		Cron::main();
	}
}