'use strict';

define(['app'], function(app) {

	app.controller("destinationS3", ["$scope", "lang", function ($scope, lang) {

		$scope.$emit('options', { disklimit: false });

		$scope.selected_vendor = "";
		$scope.selected_region = "0";

		$scope.vendors = {
			amazon: {name: "AmazonS3", endpoint: "s3.{region}.amazonaws.com", extrafields: [], regions: [
					{name: lang.t("Custom Region"), value: ""},
					{name: "North Virginia, United States East", group: "North America", value: "us-east-1"},
					{name: "Ohio, United States East", group: "North America", value: "us-east-2"},
					{name: "Oregon, United States West", group: "North America", value: "us-west-2"},
					{name: "North California, United States West", group: "North America", value: "us-west-1"},
					{name: "Canada Central", group: "North America", value: "ca-central-1"},
					{name: "São Paulo, Brazil", group: "South America", value: "sa-east-1"},
					{name: "Frankfurt, Germany", group: "Europe", value: "eu-central-1"},
					{name: "Ireland", group: "Europe", value: "eu-west-1"},
					{name: "London, United Kingdom", group: "Europe", value: "eu-west-2"},
					{name: "Paris, France", group: "Europe", value: "eu-west-3"},
					{name: "Stockholm, Sweden", group: "Europe", value: "eu-north-1"},
					{name: "Singapore", group: "Asia Pacific", value: "ap-southeast-1"},
					{name: "Sydney, Australia", group: "Asia Pacific", value: "ap-southeast-2"},
					{name: "Tokyo, Japan", group: "Asia Pacific", value: "ap-northeast-1"},
					{name: "Seoul, South Korea", group: "Asia Pacific", value: "ap-northeast-2"},
					{name: "Mumbai, India", group: "Asia Pacific", value: "ap-south-1"}
				]},
			googlecloud: {name: "Google Cloud", endpoint: "storage.googleapis.com", extrafields: [], regions: false},
			oracle: {name: "Oracle Cloud", endpoint: "{namespace}.compat.objectstorage.{region}.oraclecloud.com", extrafields: [
					{label: 'Namespace', description: '', name:'namespace'}
				], regions: [
					{name: lang.t("Custom Region"), value: ""},
					{name: "Amsterdam, Netherlands Northwest", group: "Europe", value: "eu-amsterdam-1"},
					{name: "Sydney, Australia East", group: "Australia", value: "ap-sydney-1"},
					{name: "Melbourne, Australia Southeast", group: "Australia", value: "ap-melbourne-1"},
					{name: "Sao Paulo, Brazil East", group: "South America", value: "sa-saopaulo-1"},
					{name: "Montreal, Canada Southeast", group: "North America", value: "ca-montreal-1"},
					{name: "Toronto, Canada Southeast", group: "North America", value: "ca-toronto-1"},
					{name: "Santiago, Chile Central", group: "South America", value: "sa-santiago-1"},
					{name: "Frankfurt, Germany Central", group: "Europe", value: "eu-frankfurt-1"},
					{name: "Hyderabad, India South", group: "Asia Pacific", value: "ap-hyderabad-1"},
					{name: "Mumbai, India West", group: "Asia Pacific", value: "ap-mumbai-1"},
					{name: "Osaka, Japan Central", group: "Asia Pacific", value: "ap-osaka-1"},
					{name: "Tokyo, Japan East", group: "Asia Pacific", value: "ap-tokyo-1"},
					{name: "Jeddah, Saudi Arabia West", group: "Middle East", value: "me-jeddah-1"},
					{name: "Seoul, South Korea Central", group: "Asia Pacific", value: "ap-seoul-1"},
					{name: "Chuncheon, South Korea North", group: "Asia Pacific", value: "ap-chuncheon-1"},
					{name: "Zurich, Switzerland North", group: "Europe", value: "eu-zurich-1"},
					{name: "Dubai, UAE East", group: "Middle East", value: "me-dubai-1"},
					{name: "London, United Kingdom South", group: "Europe", value: "uk-london-1"},
					{name: "Newport, United Kingdom West", group: "Europe", value: "uk-cardiff-1"},
					{name: "Ashburn, United States East", group: "North America", value: "us-ashburn-1"},
					{name: "Phoenix, United States West", group: "North America", value: "us-phoenix-1"},
					{name: "San Jose, United States West", group: "North America", value: "us-sanjose-1"}
				]},
			wasabi: {name: "Wasabi", endpoint: "s3.{region}.wasabisys.com", extrafields: [], regions: [
					{name: lang.t("Custom Region"), value: ""},
					{name: "North Virginia 1, United States East", group: "North America", value: "us-east-1"},
					{name: "North Virginia 2, United States East", group: "North America", value: "us-east-2"},
					{name: "Oregon, United States West", group: "North America", value: "us-west-1"},
					{name: "Texas, United States Central", group: "North America", value: "us-central-1"},
					{name: "Amsterdam, Netherlands", group: "Europe", value: "eu-central-1"},
					{name: "London, England", group: "Europe", value: "eu-west-1"},
					{name: "Paris, France", group: "Europe", value: "eu-west-2"},
					{name: "Tokyo, Japan", group: "Asia Pacific", value: "ap-northeast-1"},
					{name: "Osaka, Japan", group: "Asia Pacific", value: "ap-northeast-2"}
				]},
			digitalocean: {name: "DigitalOcean Spaces", endpoint: "{region}.digitaloceanspaces.com", extrafields: [], regions: [
					{name: lang.t("Custom Region"), value: ""},
					{name: "New York, United States East", group: "North America", value: "nyc3"},
					{name: "North California, United States West", group: "North America", value: "sfo2"},
					//{name: "Amsterdam 1, Netherlands", group: "Central Europe", value: "ams1"},
					{name: "Amsterdam, Netherlands", group: "Europe", value: "ams3"},
					{name: "France", group: "Europe", value: "fra1"},
					{name: "Singapore", group: "Asia Pacific", value: "sgp1"}
				]},
			/*
			backblaze: {name: "BackBlaze", endpoint: "s3.{region}.backblazeb2.com", extrafields: [], regions: [
					{name: lang.t("Custom Region"), value: ""},
					{name: "Europe Central (003)", group: "Europe", value: "eu-central-003"},
					{name: "United States West (000)", group: "North America", value: "us-west-000"},
					{name: "United States West (001)", group: "North America", value: "us-west-001"},
					{name: "United States West (002)", group: "North America", value: "us-west-002"}
				]},
			 */
			ibm: {name: "IBM", endpoint: "s3.{region}.cloud-object-storage.appdomain.cloud", extrafields: [], regions: [
					{name: lang.t("Custom Region"), value: ""},
					{name: "Cross Region", group: "North America", value: "us"},
					{name: "United States South", group: "North America", value: "us-south"},
					{name: "United States East", group: "North America", value: "us-east"},
					{name: "San Jose, United States", group: "North America", value: "sjc04"},
					{name: "Mexico City, Mexico", group: "North America", value: "mex01"},
					{name: "Montrèal, Canada", group: "North America", value: "mon01"},
					{name: "Cross Region", group: "Europe", value: "eu"},
					{name: "United Kingdom", group: "Europe", value: "eu-gb"},
					{name: "Germany", group: "Europe", value: "eu-de"},
					{name: "Amsterdam, Netherlands", group: "Europe", value: "ams03"},
					{name: "Milan, Italy", group: "Europe", value: "mil01"},
					{name: "Paris, France", group: "Europe", value: "par01"},
					{name: "Oslo, Norway", group: "Europe", value: "osl01"},
					{name: "Cross Region", group: "Asia Pacific", value: "ap"},
					{name: "Australia", group: "Asia Pacific", value: "au-syd"},
					{name: "Japan", group: "Asia Pacific", value: "jp-tok"},
					{name: "Chennai, India", group: "Asia Pacific", value: "che01"},
					{name: "Hong Kong S.A.R. of the PRC", group: "Asia Pacific", value: "hkg02"}
				]},
			scaleway: {name: "Scaleway", endpoint: "s3.{region}.scw.cloud", extrafields: [], regions: [
					{name: lang.t("Custom Region"), value: ""},
					{name: "Amsterdam, Netherlands", group: "Europe", value: "nl-ams"},
					{name: "Paris, France", group: "Europe", value: "fr-par"},
				]},
			custom: {name: lang.t("Custom Vendor"), endpoint: "", extrafields: [], regions: []}
		};

		$scope.changeVendor = function(vendor_id, reset_region) {

			if(reset_region) {
				$scope.saveData.options.region = "";
				$scope.selected_region = "0";
			}

			if($scope.selected_vendor == vendor_id) return;
			$scope.selected_vendor = vendor_id;
			if(vendor_id == "custom") return;
			$scope.saveData.options.endpoint = $scope.vendors[vendor_id].endpoint;
		};

		$scope.findVendor = function(endpoint) {
			for(var id in $scope.vendors) {
				if($scope.vendors[id].endpoint == endpoint) return id;
			}
			return null;
		};

		$scope.changeRegion = function() {
			var regions = $scope.vendors[$scope.selected_vendor].regions;
			if(!regions.length) {
				$scope.saveData.options.region = "";
				$scope.selected_region = "0";
				return;
			}
			$scope.saveData.options.region = regions[$scope.selected_region].value;
			/*
			if(!regions) {
				$scope.selected_region = 0;
				return;
			}

			for(var i = 0; i < regions.length; i++) {
				if(regions[i].value == $scope.saveData.options.region) {
					$scope.selected_region = i;
					return;
				}
			}

			 */
		};

		/*
		$scope.$watch('endpoint', function () {
			var vendor = $scope.vendors[$scope.selected_vendor];
			if(vendor !== undefined && vendor.endpoint !== '') $scope.saveData.options.endpoint = vendor.endpoint;
		});

		 */

		var vendor_id = $scope.saveData.options.endpoint ? $scope.findVendor($scope.saveData.options.endpoint) : '';

		if($scope.saveData.options.path === undefined) $scope.saveData.options.path = '/';
		if($scope.saveData.options.access_key === undefined) $scope.saveData.options.access_key = '';
		if($scope.saveData.options.secret_key === undefined) $scope.saveData.options.secret_key = '';
		if($scope.saveData.options.bucket === undefined) $scope.saveData.options.bucket = '';
		if($scope.saveData.options.verifyssl === undefined) $scope.saveData.options.verifyssl = 1;
		if($scope.saveData.options.retries === undefined) $scope.saveData.options.retries = 3;
		if($scope.saveData.options.extrafields === undefined) $scope.saveData.options.extrafields = {};

		if($scope.saveData.options.region === undefined) $scope.saveData.options.region = '';
		else if(vendor_id) {
			var regions = $scope.vendors[vendor_id].regions;
			if(regions.length) {
				for(var i = 0; i < regions.length; i++) {
					console.log($scope.saveData.options.region, regions[i]);
					if($scope.saveData.options.region == regions[i].value) {
						$scope.selected_region = String(i);
						break;
					}
				}
			}
		}

		if($scope.saveData._id) {
			if($scope.saveData.options.endpoint === undefined) $scope.saveData.options.endpoint = '';
			else {
				$scope.selected_vendor = "custom";
				if(vendor_id) $scope.changeVendor(vendor_id);
			}
		} else {
			$scope.changeVendor('amazon', true);
			$scope.selected_vendor = "amazon";
		}
	}]);

});