'use strict';

define(['app'], function(app) {

	app.controller("destinationFTP", ["$scope", "lang", function ($scope, lang) {

		$scope.$emit('options', { disklimit: false, threads: true });

		if($scope.details._id === undefined) $scope.saveData.threads = 15;
		if($scope.saveData.options.passive === undefined) $scope.saveData.options.passive = '1';
		if($scope.saveData.options.secure === undefined) $scope.saveData.options.secure = '0';
		if($scope.saveData.options.port === undefined) $scope.saveData.options.port = 21;
		if($scope.saveData.options.timeout === undefined) $scope.saveData.options.timeout = 30;
		if($scope.saveData.options.retries === undefined) $scope.saveData.options.retries = 3;
		if($scope.saveData.options.prefer_ip === undefined) $scope.saveData.options.prefer_ip = 0;

		$scope.prefer_ip_options = [
			{ label: lang.t("Default Route"), value: 0 },
			{ label: "IPv4", value: 4 },
			{ label: "IPv6", value: 6 }
		];

		$scope.changeRadio = function (key, value) {
			$scope.saveData.options[key] = String(value);
		};

		$scope.castVar = function (key) {
			var type = typeof $scope.saveData.options[key];
			if(type == "string") return;
			if(type == "boolean") $scope.saveData.options[key] = $scope.saveData.options[key] ? 1 : 0;
			$scope.saveData.options[key] = String($scope.saveData.options[key]);
		}

		$scope.$watch('saveData.options.passive', function () { $scope.castVar('passive') });
		$scope.$watch('saveData.options.secure', function () { $scope.castVar('secure') });
	}]);

});